package org.nuiton.topia.it.mapping.test7;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.LinkedList;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A73Abstract extends AbstractTopiaEntity implements A73 {

    /**
     * Nom de l'attribut en BD : roleB73
     */
    protected List<B73> roleB73;

    private static final long serialVersionUID = 3631084603503502436L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_B73, List.class, B73.class, roleB73);
    }

    @Override
    public void addRoleB73(B73 roleB73) {
        if (this.roleB73 == null) {
            this.roleB73 = new LinkedList<B73>();
        }
        this.roleB73.add(roleB73);
    }

    @Override
    public void addRoleB73(int index, B73 roleB73) {
        if (this.roleB73 == null) {
            this.roleB73 = new LinkedList<B73>();
        }
        this.roleB73.add(index, roleB73);
    }

    @Override
    public void addAllRoleB73(Iterable<B73> roleB73) {
        if (roleB73 == null) {
            return;
        }
        for (B73 item : roleB73) {
            addRoleB73(item);
        }
    }

    @Override
    public void setRoleB73(List<B73> roleB73) {
        this.roleB73 = roleB73;
    }

    @Override
    public void removeRoleB73(B73 roleB73) {
        if (this.roleB73 == null || !this.roleB73.remove(roleB73)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void removeRoleB73(int index) {
        if (this.roleB73 == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        B73 oldValue = this.roleB73.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRoleB73() {
        if (this.roleB73 == null) {
            return;
        }
        this.roleB73.clear();
    }

    @Override
    public List<B73> getRoleB73() {
        return roleB73;
    }

    @Override
    public B73 getRoleB73(int index) {
        return TopiaEntityHelper.getEntityByIndex(roleB73, index);
    }

    @Override
    public B73 getRoleB73ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB73, topiaId);
    }

    @Override
    public List<String> getRoleB73TopiaIds() {
        List<String> topiaIds = new LinkedList<String>();
        List<org.nuiton.topia.it.mapping.test7.B73> tmp = getRoleB73();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB73() {
        if (roleB73 == null) {
            return 0;
        }
        return roleB73.size();
    }

    @Override
    public boolean isRoleB73Empty() {
        int size = sizeRoleB73();
        return size == 0;
    }

    @Override
    public boolean isRoleB73NotEmpty() {
        boolean empty = isRoleB73Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB73(B73 roleB73) {
        boolean contains = this.roleB73 !=null && this.roleB73.contains(roleB73);
        return contains;
    }

} //A73Abstract
