package org.nuiton.topia.it.mapping.test3;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A31Abstract extends AbstractTopiaEntity implements A31 {

    /**
     * Nom de l'attribut en BD : roleB31
     */
    protected Collection<B31> roleB31;

    private static final long serialVersionUID = 3918522209410495285L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_ROLE_B31, Collection.class, B31.class, roleB31);
    }

    @Override
    public void addRoleB31(B31 roleB31) {
        if (this.roleB31 == null) {
            this.roleB31 = new LinkedList<B31>();
        }
        this.roleB31.add(roleB31);
    }

    @Override
    public void addAllRoleB31(Iterable<B31> roleB31) {
        if (roleB31 == null) {
            return;
        }
        for (B31 item : roleB31) {
            addRoleB31(item);
        }
    }

    @Override
    public void setRoleB31(Collection<B31> roleB31) {
        this.roleB31 = roleB31;
    }

    @Override
    public void removeRoleB31(B31 roleB31) {
        if (this.roleB31 == null || !this.roleB31.remove(roleB31)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRoleB31() {
        if (this.roleB31 == null) {
            return;
        }
        this.roleB31.clear();
    }

    @Override
    public Collection<B31> getRoleB31() {
        return roleB31;
    }

    @Override
    public B31 getRoleB31ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(roleB31, topiaId);
    }

    @Override
    public Collection<String> getRoleB31TopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<org.nuiton.topia.it.mapping.test3.B31> tmp = getRoleB31();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRoleB31() {
        if (roleB31 == null) {
            return 0;
        }
        return roleB31.size();
    }

    @Override
    public boolean isRoleB31Empty() {
        int size = sizeRoleB31();
        return size == 0;
    }

    @Override
    public boolean isRoleB31NotEmpty() {
        boolean empty = isRoleB31Empty();
        return ! empty;
    }

    @Override
    public boolean containsRoleB31(B31 roleB31) {
        boolean contains = this.roleB31 !=null && this.roleB31.contains(roleB31);
        return contains;
    }

} //A31Abstract
