package org.nuiton.topia.it.mapping.test11;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.HashSet;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class A11CAbstract extends AbstractTopiaEntity implements A11C {

    /**
     * Nom de l'attribut en BD : b11C
     */
    protected Set<B11C> b11C;

    private static final long serialVersionUID = 3690760609166746928L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_B11_C, Set.class, B11C.class, b11C);
    }

    @Override
    public void addB11C(B11C b11C) {
        if (this.b11C == null) {
            this.b11C = new HashSet<B11C>();
        }
        this.b11C.add(b11C);
    }

    @Override
    public void addAllB11C(Iterable<B11C> b11C) {
        if (b11C == null) {
            return;
        }
        for (B11C item : b11C) {
            addB11C(item);
        }
    }

    @Override
    public void setB11C(Set<B11C> b11C) {
        this.b11C = b11C;
    }

    @Override
    public void removeB11C(B11C b11C) {
        if (this.b11C == null || !this.b11C.remove(b11C)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearB11C() {
        if (this.b11C == null) {
            return;
        }
        this.b11C.clear();
    }

    @Override
    public Set<B11C> getB11C() {
        return b11C;
    }

    @Override
    public B11C getB11CByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(b11C, topiaId);
    }

    @Override
    public Set<String> getB11CTopiaIds() {
        Set<String> topiaIds = new HashSet<String>();
        Set<org.nuiton.topia.it.mapping.test11.B11C> tmp = getB11C();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeB11C() {
        if (b11C == null) {
            return 0;
        }
        return b11C.size();
    }

    @Override
    public boolean isB11CEmpty() {
        int size = sizeB11C();
        return size == 0;
    }

    @Override
    public boolean isB11CNotEmpty() {
        boolean empty = isB11CEmpty();
        return ! empty;
    }

    @Override
    public boolean containsB11C(B11C b11C) {
        boolean contains = this.b11C !=null && this.b11C.contains(b11C);
        return contains;
    }

} //A11CAbstract
