package org.nuiton.topia.it.mapping;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2020 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnumProvider;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContextConstructorParameter;
import org.nuiton.topia.persistence.util.EntityOperator;

public abstract class AbstractTopiaItMappingTopiaApplicationContext extends AbstractTopiaApplicationContext<TopiaItMappingTopiaPersistenceContext> implements TopiaEntityEnumProvider<TopiaItMappingEntityEnum> {

    @Deprecated
    protected AbstractTopiaItMappingTopiaApplicationContext(Properties properties) {
        super(properties);
    }

    @Deprecated
    protected AbstractTopiaItMappingTopiaApplicationContext(Map<String, String> configuration) {
        super(configuration);
    }

    protected AbstractTopiaItMappingTopiaApplicationContext(TopiaConfiguration topiaConfiguration) {
        super(topiaConfiguration);
    }

    @Override
    public TopiaItMappingTopiaPersistenceContext newPersistenceContext() {

        TopiaItMappingTopiaPersistenceContext newContext = new TopiaItMappingTopiaPersistenceContext(
                new AbstractTopiaPersistenceContextConstructorParameter(
                        getHibernateProvider(),
                        getTopiaFiresSupport(),
                        getTopiaIdFactory(),
                        getSessionRegistry(),
                        getConfiguration().getSlowQueriesThreshold()
                )
        );
        registerPersistenceContext(newContext);
        return newContext;
    }

    @Override
    public String getModelVersion() {
        return "1.0.5";
    }

    @Override
    public String getModelName() {
        return "TopiaItMapping";
    }

    @Override
    public <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        return TopiaItMappingEntityEnum.getContractClass(klass);
    }

    @Override
    public Class<? extends TopiaEntity>[] getContractClasses() {
        return TopiaItMappingEntityEnum.getContractClasses();
    }

    @Override
    public <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        return TopiaItMappingEntityEnum.getImplementationClass(klass);
    }

    @Override
    public Set<Class<? extends TopiaEntity>> getImplementationClasses() {
        return TopiaItMappingEntityEnum.getImplementationClasses();
    }

    public TopiaItMappingEntityEnum[] getContracts() {
        return TopiaItMappingEntityEnum.getContracts();
    }

    public <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        return TopiaItMappingEntityEnum.getOperator(klass);
    }

    @Override
    public <E extends TopiaEntity> TopiaItMappingEntityEnum getEntityEnum(Class<E> type) {
        return TopiaItMappingEntityEnum.valueOf(type);
    }

    @Override
    public TopiaItMappingEntityEnum getEntityEnum(String name) {
        return TopiaItMappingEntityEnum.valueOf(name);
    }

} //AbstractTopiaItMappingTopiaApplicationContext
