/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.it.legacy.topiatest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.it.legacy.topiatest.Bill;
import org.nuiton.topia.it.legacy.topiatest.Company;
import org.nuiton.topia.it.legacy.topiatest.Department;
import org.nuiton.topia.it.legacy.topiatest.Employe;
import org.nuiton.topia.it.legacy.topiatest.Store;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class CompanyAbstract
extends TopiaEntityAbstract
implements Company {
    protected String name;
    protected int siret;
    protected Collection<Employe> employe;
    protected Collection<Bill> storeBill;
    protected Collection<Department> department;
    private static final long serialVersionUID = 4121691295267055154L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "siret", Integer.TYPE, (Object)this.siret);
        visitor.visit((TopiaEntity)this, "employe", Collection.class, Employe.class, this.employe);
        visitor.visit((TopiaEntity)this, "storeBill", Collection.class, Bill.class, this.storeBill);
        visitor.visit((TopiaEntity)this, "department", Collection.class, Department.class, this.department);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setSiret(int siret) {
        int oldValue = this.siret;
        this.fireOnPreWrite("siret", oldValue, siret);
        this.siret = siret;
        this.fireOnPostWrite("siret", oldValue, siret);
    }

    @Override
    public int getSiret() {
        this.fireOnPreRead("siret", this.siret);
        int result = this.siret;
        this.fireOnPostRead("siret", this.siret);
        return result;
    }

    @Override
    public void addEmploye(Employe employe) {
        this.fireOnPreWrite("employe", null, employe);
        if (this.employe == null) {
            this.employe = new ArrayList<Employe>();
        }
        this.employe.add(employe);
        this.fireOnPostWrite("employe", this.employe.size(), null, employe);
    }

    @Override
    public void addAllEmploye(Collection<Employe> employe) {
        if (employe == null) {
            return;
        }
        for (Employe item : employe) {
            this.addEmploye(item);
        }
    }

    @Override
    public void setEmploye(Collection<Employe> employe) {
        ArrayList<Employe> oldValue = this.employe != null ? new ArrayList<Employe>(this.employe) : null;
        this.fireOnPreWrite("employe", oldValue, employe);
        this.employe = employe;
        this.fireOnPostWrite("employe", oldValue, employe);
    }

    @Override
    public void removeEmploye(Employe employe) {
        this.fireOnPreWrite("employe", employe, null);
        if (this.employe == null || !this.employe.remove(employe)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("employe", this.employe.size() + 1, employe, null);
    }

    @Override
    public void clearEmploye() {
        if (this.employe == null) {
            return;
        }
        ArrayList<Employe> oldValue = new ArrayList<Employe>(this.employe);
        this.fireOnPreWrite("employe", oldValue, this.employe);
        this.employe.clear();
        this.fireOnPostWrite("employe", oldValue, this.employe);
    }

    @Override
    public Collection<Employe> getEmploye() {
        return this.employe;
    }

    @Override
    public Employe getEmployeByTopiaId(String topiaId) {
        return (Employe)TopiaEntityHelper.getEntityByTopiaId(this.employe, (String)topiaId);
    }

    @Override
    public int sizeEmploye() {
        if (this.employe == null) {
            return 0;
        }
        return this.employe.size();
    }

    @Override
    public boolean isEmployeEmpty() {
        int size = this.sizeEmploye();
        return size == 0;
    }

    @Override
    public void addStoreBill(Bill storeBill) {
        this.fireOnPreWrite("storeBill", null, storeBill);
        if (this.storeBill == null) {
            this.storeBill = new ArrayList<Bill>();
        }
        this.storeBill.add(storeBill);
        this.fireOnPostWrite("storeBill", this.storeBill.size(), null, storeBill);
    }

    @Override
    public void addAllStoreBill(Collection<Bill> storeBill) {
        if (storeBill == null) {
            return;
        }
        for (Bill item : storeBill) {
            this.addStoreBill(item);
        }
    }

    @Override
    public void setStoreBill(Collection<Bill> storeBill) {
        ArrayList<Bill> oldValue = this.storeBill != null ? new ArrayList<Bill>(this.storeBill) : null;
        this.fireOnPreWrite("storeBill", oldValue, storeBill);
        this.storeBill = storeBill;
        this.fireOnPostWrite("storeBill", oldValue, storeBill);
    }

    @Override
    public void removeStoreBill(Bill storeBill) {
        this.fireOnPreWrite("storeBill", storeBill, null);
        if (this.storeBill == null || !this.storeBill.remove(storeBill)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        this.fireOnPostWrite("storeBill", this.storeBill.size() + 1, storeBill, null);
    }

    @Override
    public void clearStoreBill() {
        if (this.storeBill == null) {
            return;
        }
        ArrayList<Bill> oldValue = new ArrayList<Bill>(this.storeBill);
        this.fireOnPreWrite("storeBill", oldValue, this.storeBill);
        this.storeBill.clear();
        this.fireOnPostWrite("storeBill", oldValue, this.storeBill);
    }

    @Override
    public Collection<Bill> getStoreBill() {
        return this.storeBill;
    }

    @Override
    public Bill getStoreBillByTopiaId(String topiaId) {
        return (Bill)TopiaEntityHelper.getEntityByTopiaId(this.storeBill, (String)topiaId);
    }

    @Override
    public Bill getStoreBill(Store store) {
        if (store == null || this.storeBill == null) {
            return null;
        }
        for (Bill item : this.storeBill) {
            if (!store.equals(item.getStore())) continue;
            return item;
        }
        return null;
    }

    @Override
    public int sizeStoreBill() {
        if (this.storeBill == null) {
            return 0;
        }
        return this.storeBill.size();
    }

    @Override
    public boolean isStoreBillEmpty() {
        int size = this.sizeStoreBill();
        return size == 0;
    }

    @Override
    public void addDepartment(Department department) {
        this.fireOnPreWrite("department", null, department);
        if (this.department == null) {
            this.department = new ArrayList<Department>();
        }
        department.setCompany(this);
        this.department.add(department);
        this.fireOnPostWrite("department", this.department.size(), null, department);
    }

    @Override
    public void addAllDepartment(Collection<Department> department) {
        if (department == null) {
            return;
        }
        for (Department item : department) {
            this.addDepartment(item);
        }
    }

    @Override
    public void setDepartment(Collection<Department> department) {
        ArrayList<Department> oldValue = this.department != null ? new ArrayList<Department>(this.department) : null;
        this.fireOnPreWrite("department", oldValue, department);
        this.department = department;
        this.fireOnPostWrite("department", oldValue, department);
    }

    @Override
    public void removeDepartment(Department department) {
        this.fireOnPreWrite("department", department, null);
        if (this.department == null || !this.department.remove(department)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        department.setCompany(null);
        this.fireOnPostWrite("department", this.department.size() + 1, department, null);
    }

    @Override
    public void clearDepartment() {
        if (this.department == null) {
            return;
        }
        for (Department item : this.department) {
            item.setCompany(null);
        }
        ArrayList<Department> oldValue = new ArrayList<Department>(this.department);
        this.fireOnPreWrite("department", oldValue, this.department);
        this.department.clear();
        this.fireOnPostWrite("department", oldValue, this.department);
    }

    @Override
    public Collection<Department> getDepartment() {
        return this.department;
    }

    @Override
    public Department getDepartmentByTopiaId(String topiaId) {
        return (Department)TopiaEntityHelper.getEntityByTopiaId(this.department, (String)topiaId);
    }

    @Override
    public int sizeDepartment() {
        if (this.department == null) {
            return 0;
        }
        return this.department.size();
    }

    @Override
    public boolean isDepartmentEmpty() {
        int size = this.sizeDepartment();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("siret", this.siret).append("employe", this.employe).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.company", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.name", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.siret", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.employe", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.store", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.department", (Object[])new Object[0]);
    }
}

