CodeMirror UI
=============

CodeMirrorUI is a simple interface written by Jeremy Green to act as a 
wrapper around the [CodeMirror](http://codemirror.net/) text editor widget by Marijn Haverbeke.
CodeMirror is a syntax highlighter and formatter that makes it much easier to edit source code in a browser.
CodeMirrorUI is a wrapper that adds interface functionality for many functions that are already built into CodeMirror itself.
Functionality includes undo, redo, jump to line, reindent selection, and reindent entire document. 
Two options for find/replace are also available.  It is based on the MirrorFrame example that Marijn included with CodeMirror.

[![Code Climate](https://codeclimate.com/repos/52f67c9d695680748c002493/badges/d52fc7dbf6d0943c61ea/gpa.png)](https://codeclimate.com/repos/52f67c9d695680748c002493/feed)

Demo
-------------------

[http://jagthedrummer.github.io/codemirror-ui/](http://jagthedrummer.github.io/codemirror-ui/)

Upgrading
-------------------
*Note* Starting with version 0.0.17 CodeMirror-UI upgraded to CodeMirror-2.3.  The find and replace functionality relies
on the searchcursor add-on for CodeMirror.  Make sure to add the searchcursor line from the installation instructions if 
the search/replace is not working.

Easily Configurable
--------------------

It's easy to configure an editor with something like this:

    //first set up some variables
    var textarea = document.getElementById('code1');
    var uiOptions = { path : 'js/', searchMode: 'popup' }
    var codeMirrorOptions = {
        mode: "javascript" // all your normal CodeMirror options go here
    }
    
    //then create the editor
    var editor = new CodeMirrorUI(textarea,uiOptions,codeMirrorOptions);
			
Installation
--------------------

    // First the CodeMirror stuff
    <script src="lib/CodeMirror-2.3/lib/codemirror.js" type="text/javascript"></script>
    <script src="lib/CodeMirror-2.3/lib/util/searchcursor.js" type="text/javascript"></script>
    <link rel="stylesheet" href="lib/CodeMirror-2.3/lib/codemirror.css">
    <script src="lib/CodeMirror-2.3/mode/javascript/javascript.js"></script>
    <link rel="stylesheet" href="lib/CodeMirror-2.3/mode/javascript/javascript.css">
    
    //Then the CodeMirrorUI stuff
    <script src="js/codemirror-ui.js" type="text/javascript"></script>
    <link rel="stylesheet" href="css/codemirror-ui.css" type="text/css" media="screen" />

You'll probably need to adjust the paths to fit your situation.

Please see index.html for examples and many additional details.

Acknowledgements
----------------------

Thanks to Marijn Haverbeke for creating and releasing [CodeMirror](http://codemirror.net/) in the first place.  
Without his excellent contribution to the community this project would have no reason to exist.

Thanks to Mark James of famfamfam.com for his [Silk Icons](http://www.famfamfam.com/lab/icons/silk/).

License
----------------------

CodeMirror UI is provided under the MIT License.  See the LICENSE file for full details.
