/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.LoggingException;

public class LoggingPatternFormatter
extends Formatter {
    private static final Log log = LogFactory.getLog(LoggingPatternFormatter.class);
    private static final String DEFAULT_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} [free:%o{-7}|total:%O{-7}][%t][%p{7}] %c{org.nuiton.*|25} %M{15:105}: %m%n%e";
    protected HashMap<String, Class<?>> arguments = null;
    protected ArrayList<Argument> compile = null;
    protected String pattern = null;

    public LoggingPatternFormatter() {
        try {
            this.arguments = new HashMap();
            this.initArguments();
            LogManager manager = LogManager.getLogManager();
            String cname = this.getClass().getName();
            this.pattern = manager.getProperty(cname + ".pattern");
            if (this.pattern == null) {
                this.pattern = DEFAULT_PATTERN;
            }
            this.compilePattern(this.pattern);
        }
        catch (Exception eee) {
            log.error("Impossible d'utiliser le PatternFormatter", eee);
            throw new LoggingException("Exception durant l'initialisation du PatternFormatter", eee);
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer result = new StringBuffer();
        Iterator<Argument> i = this.compile.iterator();
        while (i.hasNext()) {
            i.next().toString(record, result);
        }
        return result.toString();
    }

    protected void initArguments() {
        this.arguments.put("d", DateArgument.class);
        this.arguments.put("o", FreeMemoryArgument.class);
        this.arguments.put("O", TotalMemoryArgument.class);
        this.arguments.put("t", ThreadArgument.class);
        this.arguments.put("p", PriorityLevelArgument.class);
        this.arguments.put("c", ClassNameArgument.class);
        this.arguments.put("M", MethodNameArgument.class);
        this.arguments.put("m", MessageArgument.class);
        this.arguments.put("e", ExceptionArgument.class);
    }

    protected void compilePattern(String pattern) {
        this.compile = new ArrayList();
        String[] match = this.findNextPattern(pattern);
        while (!match[1].equals("")) {
            this.compile.add(new StringArgument(match[0]));
            this.compile.add(this.patternToArgument(match[1]));
            match = this.findNextPattern(match[2]);
        }
        this.compile.add(new StringArgument(match[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] findNextPattern(String s2) {
        String[] result = new String[]{"", "", ""};
        if (s2 == null) {
            return result;
        }
        int d = s2.indexOf("%");
        if (d != -1) {
            if (d + 2 < s2.length() && s2.charAt(d + 2) == '{') {
                int f = s2.indexOf("}", d);
                if (f == -1) throw new LoggingException("Error, { at position " + (d + 2) + " not terminated in :" + s2);
                result[0] = s2.substring(0, d);
                result[1] = s2.substring(d + 1, f);
                result[2] = s2.substring(f + 1);
                return result;
            } else {
                result[0] = s2.substring(0, d);
                result[1] = s2.substring(d + 1, d + 2);
                result[2] = s2.substring(d + 2);
            }
            return result;
        } else {
            result[0] = s2;
        }
        return result;
    }

    protected Argument patternToArgument(String s2) {
        Argument argument;
        if (s2.charAt(0) == 'n') {
            return new StringArgument("\n");
        }
        if (s2.charAt(0) == '%') {
            return new StringArgument("%");
        }
        if (s2.charAt(0) == '{') {
            return new StringArgument("{");
        }
        String code = s2.substring(0, 1);
        Class<?> argumentClass = this.arguments.get(code);
        if (argumentClass == null) {
            throw new LoggingException("Erreur dans le pattern '" + code + "' inconnu");
        }
        try {
            argument = (Argument)argumentClass.newInstance();
        }
        catch (InstantiationException eee) {
            throw new LoggingException("Erreur lors de l'instanciation de l'objet Argument: " + argumentClass.getName(), eee);
        }
        catch (IllegalAccessException eee) {
            throw new LoggingException("Erreur lors de l'instanciation de l'objet Argument: " + argumentClass.getName(), eee);
        }
        if (s2.length() > 1) {
            argument.setPattern(s2.substring(2));
        }
        return argument;
    }

    protected static abstract class Argument {
        protected String pattern;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public abstract StringBuffer toString(LogRecord var1, StringBuffer var2);
    }

    protected static class DateArgument
    extends Argument {
        protected SimpleDateFormat dateFormat = null;

        @Override
        public void setPattern(String pattern) {
            super.setPattern(pattern);
            this.dateFormat = new SimpleDateFormat(pattern);
        }

        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            toAppendTo.append(this.dateFormat.format(new Date(record.getMillis())));
            return toAppendTo;
        }
    }

    protected static class FreeMemoryArgument
    extends OctetArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(this.toReadableSize(Runtime.getRuntime().freeMemory(), UNITE, this.diviseur), toAppendTo);
        }
    }

    protected static class TotalMemoryArgument
    extends OctetArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(this.toReadableSize(Runtime.getRuntime().totalMemory(), UNITE, this.diviseur), toAppendTo);
        }
    }

    protected static class ThreadArgument
    extends SizedArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(Thread.currentThread().getName(), toAppendTo);
        }
    }

    protected static class PriorityLevelArgument
    extends SizedArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(record.getLevel().toString(), toAppendTo);
        }
    }

    protected static class ClassNameArgument
    extends SubStringArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(this.substring(record.getSourceClassName()), toAppendTo);
        }
    }

    protected static class MethodNameArgument
    extends SizedArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(record.getSourceMethodName(), toAppendTo);
        }
    }

    protected static class MessageArgument
    extends SizedArgument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            return this.justify(record.getMessage(), toAppendTo);
        }
    }

    protected static class ExceptionArgument
    extends Argument {
        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            Throwable e = record.getThrown();
            if (e != null) {
                toAppendTo.append(e.getMessage());
                toAppendTo.append("\n");
                StringWriter st = new StringWriter();
                e.printStackTrace(new PrintWriter(st));
                toAppendTo.append(st.toString());
                toAppendTo.append("\n");
            }
            return toAppendTo;
        }
    }

    protected static class StringArgument
    extends Argument {
        protected String s = null;

        public StringArgument(String s2) {
            this.s = s2;
        }

        @Override
        public StringBuffer toString(LogRecord record, StringBuffer toAppendTo) {
            toAppendTo.append(this.s);
            return toAppendTo;
        }
    }

    protected static abstract class OctetArgument
    extends SizedArgument {
        protected static final String[] UNITE = new String[]{"o", "Ko", "Mo", "Go", "To", "Po"};
        protected int diviseur = 1024;

        protected String toReadableSize(long size, String[] unit, int diviseur) {
            int unitIndex;
            for (unitIndex = 0; size > 99999L && unitIndex < unit.length; size /= (long)diviseur, ++unitIndex) {
            }
            String result = size + unit[unitIndex];
            return result;
        }
    }

    protected static abstract class SubStringArgument
    extends SizedArgument {
        protected String removeString = null;
        protected boolean atBeginning = true;

        @Override
        public void setPattern(String pattern) {
            String[] subpattern = pattern.split("\\|");
            for (int i = 0; i < subpattern.length; ++i) {
                try {
                    super.setPattern(subpattern[i]);
                    continue;
                }
                catch (NumberFormatException eee) {
                    boolean bl = this.atBeginning = subpattern[i].charAt(0) != '*';
                    if (subpattern[i].charAt(0) == '*') {
                        this.removeString = subpattern[i].substring(1);
                        continue;
                    }
                    if (!subpattern[i].endsWith("*")) continue;
                    this.removeString = subpattern[i].substring(0, subpattern[i].length() - 1);
                }
            }
        }

        protected String substring(String s2) {
            if (this.atBeginning) {
                if (s2.startsWith(this.removeString)) {
                    return s2.substring(this.removeString.length());
                }
            } else if (s2.endsWith(this.removeString)) {
                return s2.substring(0, s2.length() - this.removeString.length());
            }
            return s2;
        }
    }

    protected static abstract class SizedArgument
    extends Argument {
        protected boolean left = true;
        protected int width = 0;
        protected int maxPos = -1;

        @Override
        public void setPattern(String pattern) {
            super.setPattern(pattern);
            if (pattern.length() > 0) {
                String[] subpattern = pattern.split(":");
                pattern = subpattern[0];
                char op = pattern.charAt(0);
                if (pattern.charAt(0) == '+' || pattern.charAt(0) == '-') {
                    pattern = pattern.substring(1);
                }
                this.width = Integer.parseInt(pattern);
                boolean bl = this.left = op != '-';
                if (subpattern.length > 1) {
                    this.maxPos = Integer.parseInt(subpattern[1]);
                }
            }
        }

        protected StringBuffer justify(String s2, StringBuffer toAppendTo) {
            int blanc = this.width - s2.length();
            if (this.left) {
                toAppendTo.append(s2);
                while (0 < blanc-- && (this.maxPos == -1 || toAppendTo.length() < this.maxPos)) {
                    toAppendTo.append(" ");
                }
            } else {
                while (0 < blanc-- && (this.maxPos == -1 || toAppendTo.length() < this.maxPos)) {
                    toAppendTo.append(" ");
                }
                toAppendTo.append(s2);
            }
            return toAppendTo;
        }
    }
}

