/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class ArtifactHelper {
    protected static Comparator<MavenProject> projectComparator;

    public static String getArtifactId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append("--");
        sb.append(artifact.getArtifactId());
        sb.append("--");
        sb.append(artifact.getVersion());
        String type = artifact.getType();
        if (!StringUtils.isEmpty((String)type) && !"pom".equals(type)) {
            sb.append("--");
            sb.append(artifact.getType());
        }
        if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
            sb.append("--");
            sb.append(artifact.getClassifier());
        }
        return sb.toString();
    }

    public static String getArtifactName(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        if (project.getName().startsWith("Unnamed -")) {
            sb.append(project.getArtifactId());
        } else {
            sb.append(project.getName());
        }
        sb.append(" (");
        sb.append(project.getGroupId());
        sb.append(":");
        sb.append(project.getArtifactId());
        sb.append(":");
        sb.append(project.getVersion());
        sb.append(" - ");
        String url = project.getUrl();
        sb.append(url == null ? "no url defined" : url);
        sb.append(")");
        return sb.toString();
    }

    public static Comparator<MavenProject> getProjectComparator() {
        if (projectComparator == null) {
            projectComparator = new Comparator<MavenProject>(){

                @Override
                public int compare(MavenProject o1, MavenProject o2) {
                    String id1 = ArtifactHelper.getArtifactId(o1.getArtifact());
                    String id2 = ArtifactHelper.getArtifactId(o2.getArtifact());
                    return id1.compareTo(id2);
                }
            };
        }
        return projectComparator;
    }
}

