/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.plugin.PluginWithEncoding;

public class LicenseListMojo
extends AbstractLicenseMojo
implements PluginWithEncoding {
    private String extraResolver;
    private boolean detail;
    private String encoding;
    protected LicenseStore licenseStore;

    protected void init() throws Exception {
        this.licenseStore = this.createLicenseStore(this.extraResolver);
    }

    public void doAction() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        if (this.isVerbose()) {
            buffer.append("\n\n-------------------------------------------------------------------------------\n");
            buffer.append("                           maven-license-plugin\n");
            buffer.append("-------------------------------------------------------------------------------\n\n");
        }
        buffer.append("Available licenses :\n\n");
        List<String> names = Arrays.asList(this.licenseStore.getLicenseNames());
        int maxLength = 0;
        for (String name : names) {
            if (name.length() <= maxLength) continue;
            maxLength = name.length();
        }
        Collections.sort(names);
        String pattern = " * %1$-" + maxLength + "s : %2$s\n";
        for (String licenseName : names) {
            License license = this.licenseStore.getLicense(licenseName);
            buffer.append(String.format(pattern, licenseName, license.getDescription()));
            if (!this.detail) continue;
            try {
                buffer.append("\n");
                buffer.append(license.getHeaderContent(this.getEncoding()));
                buffer.append("\n\n");
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not instanciate license with name " + licenseName + " for reason " + ex.getMessage(), (Exception)ex);
            }
        }
        this.getLog().info((CharSequence)buffer.toString());
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getExtraResolver() {
        return this.extraResolver;
    }

    public void setExtraResolver(String extraResolver) {
        this.extraResolver = extraResolver;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }
}

