/*
 * $Id$
 */

package org.nuiton.license.plugin.model.descriptor;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *         The license project descriptor describe licenses used in
 * a project.
 *         <p/>
 *         <ul>
 *           <li>mainLicense of the project</li>
 *           <li>headers to update (or add) on sources of the
 * project</li>
 *         </ul>
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class LicenseProjectDescriptor
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *              The main license of the project (or module).
     * The LICENSE.txt will
     *              contains the content of this license.
     *              
     *           
     */
    private String mainLicense;

    /**
     * Field headers.
     */
    private java.util.List<Header> headers;

    /**
     * 
     *             
     *             To add a single header.
     * 
     *             {@link Header}
     *             
     *           .
     */
    private Header header;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addHeader.
     * 
     * @param header
     */
    public void addHeader( Header header )
    {
        if ( !(header instanceof Header) )
        {
            throw new ClassCastException( "LicenseProjectDescriptor.addHeaders(header) parameter must be instanceof " + Header.class.getName() );
        }
        getHeaders().add( header );
    } //-- void addHeader( Header )

    /**
     * Get 
     *             
     *             To add a single header.
     * 
     *             {@link Header}
     *             
     *           .
     * 
     * @return Header
     */
    public Header getHeader()
    {
        return this.header;
    } //-- Header getHeader()

    /**
     * Method getHeaders.
     * 
     * @return List
     */
    public java.util.List<Header> getHeaders()
    {
        if ( this.headers == null )
        {
            this.headers = new java.util.ArrayList<Header>();
        }

        return this.headers;
    } //-- java.util.List<Header> getHeaders()

    /**
     * Get 
     *             
     *              The main license of the project (or module).
     * The LICENSE.txt will
     *              contains the content of this license.
     *              
     *           
     * 
     * @return String
     */
    public String getMainLicense()
    {
        return this.mainLicense;
    } //-- String getMainLicense()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Method removeHeader.
     * 
     * @param header
     */
    public void removeHeader( Header header )
    {
        if ( !(header instanceof Header) )
        {
            throw new ClassCastException( "LicenseProjectDescriptor.removeHeaders(header) parameter must be instanceof " + Header.class.getName() );
        }
        getHeaders().remove( header );
    } //-- void removeHeader( Header )

    /**
     * Set 
     *             
     *             To add a single header.
     * 
     *             {@link Header}
     *             
     *           .
     * 
     * @param header
     */
    public void setHeader( Header header )
    {
        this.header = header;
    } //-- void setHeader( Header )

    /**
     * Set 
     *             
     *             Collection of header.
     *             
     *             {@link Header}
     *             
     *           .
     * 
     * @param headers
     */
    public void setHeaders( java.util.List<Header> headers )
    {
        this.headers = headers;
    } //-- void setHeaders( java.util.List )

    /**
     * Set 
     *             
     *              The main license of the project (or module).
     * The LICENSE.txt will
     *              contains the content of this license.
     *              
     *           
     * 
     * @param mainLicense
     */
    public void setMainLicense( String mainLicense )
    {
        this.mainLicense = mainLicense;
    } //-- void setMainLicense( String )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )


}
