/*
 * $Id$
 */

package org.nuiton.license.plugin.model.descriptor;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         
 *           A fileSet allows the inclusion of groups of files into
 * the license set
 *           and defines also the type of header to generate.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
public class FileSet
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and
     *             Subversion
     *             metadata files, should be used when calculating
     * the files affected
     *             by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     */
    private boolean useDefaultExcludes = true;

    /**
     * 
     *             Sets the basedir directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    private String basedir;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * 
     *             
     *             <p>
     *             To add a single include.
     *             </p>
     *             When &lt;include&gt; subelements are present,
     * they define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     *             
     *           
     */
    private String include;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             <p>
     *             To add a single exclude.
     *             </p>
     *             When &lt;exclude&gt; subelements are present,
     * they define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     *             
     *           
     */
    private String exclude;

    /**
     * 
     *             
     *             Sets the line-endings of the files in this
     * fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    private String lineEnding;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileSet.addExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileSet.addIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get 
     *             Sets the basedir directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @return String
     */
    public String getBasedir()
    {
        return this.basedir;
    } //-- String getBasedir()

    /**
     * Get 
     *             
     *             <p>
     *             To add a single exclude.
     *             </p>
     *             When &lt;exclude&gt; subelements are present,
     * they define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     *             
     *           
     * 
     * @return String
     */
    public String getExclude()
    {
        return this.exclude;
    } //-- String getExclude()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get 
     *             
     *             <p>
     *             To add a single include.
     *             </p>
     *             When &lt;include&gt; subelements are present,
     * they define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     *             
     *           
     * 
     * @return String
     */
    public String getInclude()
    {
        return this.include;
    } //-- String getInclude()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get 
     *             
     *             Sets the line-endings of the files in this
     * fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     * 
     * @return String
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding()

    /**
     * Get 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and
     *             Subversion
     *             metadata files, should be used when calculating
     * the files affected
     *             by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes()

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileSet.removeExcludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileSet.removeIncludes(string) parameter must be instanceof " + String.class.getName() );
        }
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set 
     *             Sets the basedir directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     * 
     * @param basedir
     */
    public void setBasedir( String basedir )
    {
        this.basedir = basedir;
    } //-- void setBasedir( String )

    /**
     * Set 
     *             
     *             <p>
     *             To add a single exclude.
     *             </p>
     *             When &lt;exclude&gt; subelements are present,
     * they define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     *             
     *           
     * 
     * @param exclude
     */
    public void setExclude( String exclude )
    {
        this.exclude = exclude;
    } //-- void setExclude( String )

    /**
     * Set 
     *             
     *             When &lt;exclude&gt; subelements are present,
     * they define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     *             
     *           
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set 
     *             
     *             <p>
     *             To add a single include.
     *             </p>
     *             When &lt;include&gt; subelements are present,
     * they define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     *             
     *           
     * 
     * @param include
     */
    public void setInclude( String include )
    {
        this.include = include;
    } //-- void setInclude( String )

    /**
     * Set 
     *             
     *             When &lt;include&gt; subelements are present,
     * they define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     *             
     *           
     * 
     * @param includes
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set 
     *             
     *             Sets the line-endings of the files in this
     * fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     * 
     * @param lineEnding
     */
    public void setLineEnding( String lineEnding )
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding( String )

    /**
     * Set 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and
     *             Subversion
     *             metadata files, should be used when calculating
     * the files affected
     *             by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     * 
     * @param useDefaultExcludes
     */
    public void setUseDefaultExcludes( boolean useDefaultExcludes )
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes( boolean )


}
