/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.nuiton.license.plugin.AbstractLicenseWithDescriptorMojo;
import org.nuiton.license.plugin.header.FileHeader;
import org.nuiton.license.plugin.header.FileHeaderProcessor;
import org.nuiton.license.plugin.header.FileHeaderProcessorConfiguration;
import org.nuiton.license.plugin.header.InvalideFileHeaderException;
import org.nuiton.license.plugin.header.UpdateFileHeaderFilter;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;
import org.nuiton.license.plugin.model.License;
import org.nuiton.license.plugin.model.descriptor.FileSet;
import org.nuiton.license.plugin.model.descriptor.Header;
import org.nuiton.plugin.PluginHelper;

public class UpdateFileHeaderMojo
extends AbstractLicenseWithDescriptorMojo
implements FileHeaderProcessorConfiguration {
    protected String projectName;
    protected String organizationName;
    protected String inceptionYear;
    protected boolean addSvnKeyWords;
    protected boolean updateCopyright;
    protected String ignoreTag;
    protected boolean skipUpdateLicense;
    protected boolean dryRun;
    protected boolean clearAfterOperation;
    protected FileHeaderProcessor processor;
    protected UpdateFileHeaderFilter filter;
    protected FileHeaderTransformer transformer;
    protected FileHeader header;
    protected long timestamp;
    protected Set<File> processedFiles;
    protected EnumMap<FileState, Set<File>> result;

    @Override
    public void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getIgnoreTag())) {
            this.setIgnoreTag("%%Ignore-License");
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String commentFormat = "\n  * %1$s (%2$s)";
            for (String transformerName : this.getTransformers().keySet()) {
                FileHeaderTransformer transformer = this.getTransformer(transformerName);
                String str = String.format(commentFormat, transformer.getName(), transformer.getDescription());
                buffer.append(str);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.isUpdateCopyright()) {
            this.getLog().warn((CharSequence)"updateCopyright is not still available...");
        }
        this.setTimestamp(System.nanoTime());
        this.getFilter().setUpdateCopyright(this.isUpdateCopyright());
        this.getFilter().setLog(this.getLog());
        this.getProcessor().setConfiguration(this);
        this.getProcessor().setFilter(this.filter);
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction() throws Exception {
        String format;
        StringBuilder buffer;
        this.clear();
        this.processedFiles = new HashSet<File>();
        this.result = new EnumMap(FileState.class);
        try {
            for (Header header : this.getLicenseProjectDescriptor().getHeaders()) {
                this.processHeader(header);
            }
            buffer = new StringBuilder();
            format = "Operation result on %1$s file(s) :";
        }
        catch (Throwable throwable) {
            StringBuilder buffer2 = new StringBuilder();
            String format2 = "Operation result on %1$s file(s) :";
            buffer2.append(String.format(format2, this.getProcessedFiles().size()));
            for (FileState state : FileState.values()) {
                this.reportType(state, buffer2);
            }
            this.getLog().info((CharSequence)buffer2.toString());
            if (this.isClearAfterOperation()) {
                this.clear();
            }
            throw throwable;
        }
        buffer.append(String.format(format, this.getProcessedFiles().size()));
        for (FileState state : FileState.values()) {
            this.reportType(state, buffer);
        }
        this.getLog().info((CharSequence)buffer.toString());
        if (this.isClearAfterOperation()) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHeader(Header header) throws IOException {
        String licenseName = header.getLicenseName();
        License license = this.getLicense(licenseName);
        this.getLog().info((CharSequence)("Process header '" + header.getCommentStyle() + "'"));
        this.getLog().info((CharSequence)(" - using " + license.getDescription()));
        this.setTransformer(this.getTransformer(header.getCommentStyle()));
        FileHeader defaultFileHeader = this.buildDefaultFileHeader(license, this.getProjectName(), this.getInceptionYear(), this.getOrganizationName(), this.isAddSvnKeyWords(), this.getEncoding());
        this.setHeader(defaultFileHeader);
        this.getProcessor().populateFilter();
        for (FileSet fileSet : header.getFileSets()) {
            List<String> includes;
            File basedir = new File(this.getProject().getBasedir(), fileSet.getBasedir());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(" - process file set with basedir : " + basedir));
            }
            if ((includes = fileSet.getIncludes()).isEmpty()) {
                includes.add("**/*");
            }
            List<String> excludes = fileSet.getExcludes();
            TreeMap filestoTreate = new TreeMap();
            this.getFilesToTreateForRoots(includes.toArray(new String[includes.size()]), excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]), Arrays.asList(basedir.getAbsolutePath()), filestoTreate, null);
            try {
                for (Map.Entry entry : filestoTreate.entrySet()) {
                    this.processFileEntry((File)entry.getKey(), (String[])entry.getValue());
                }
            }
            finally {
                filestoTreate.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFileEntry(File entryBasedir, String[] paths) throws IOException {
        this.getLog().info((CharSequence)(" - " + paths.length + " file(s) to treate in " + entryBasedir));
        for (String path : paths) {
            File file = new File(entryBasedir, path);
            if (this.getProcessedFiles().contains(file)) {
                this.getLog().info((CharSequence)(" - skip already processed file " + file));
                continue;
            }
            File processFile = new File(file.getAbsolutePath() + "_" + this.getTimestamp());
            boolean doFinalize = false;
            try {
                doFinalize = this.processFile(file, processFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("skip failed file : " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage())), (Throwable)e);
                FileState.fail.addFile(file, this.getResult());
                doFinalize = false;
            }
            finally {
                this.getProcessor().reset();
                this.getProcessedFiles().add(file);
                if (doFinalize) {
                    this.finalizeFile(file, processFile);
                } else {
                    this.deleteFile(processFile);
                }
            }
        }
    }

    protected boolean processFile(File file, File processFile) throws IOException {
        String content;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(" - process file " + file));
            this.getLog().debug((CharSequence)(" - will process into file " + processFile));
        }
        try {
            content = PluginHelper.readAsString((File)file, (String)this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.getIgnoreTag())) {
            this.getLog().info((CharSequence)(" - ignore file (detected " + this.getIgnoreTag() + ") " + file));
            FileState.ignore.addFile(file, this.getResult());
            return false;
        }
        FileHeaderProcessor processor = this.getProcessor();
        try {
            processor.process(file, processFile);
        }
        catch (IllegalStateException e) {
            throw new InvalideFileHeaderException("Could not extract header on file " + file, e);
        }
        catch (Exception e) {
            if (e instanceof InvalideFileHeaderException) {
                throw (InvalideFileHeaderException)e;
            }
            throw new IOException("Could not process file " + file, e);
        }
        if (processor.isTouched()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)(" - header was updated for " + file));
            }
            if (processor.isModified()) {
                FileState.update.addFile(file, this.getResult());
                return true;
            }
            FileState.uptodate.addFile(file, this.getResult());
            return false;
        }
        if (processor.isDetectHeader()) {
            throw new InvalideFileHeaderException("Could not find header end on file " + file);
        }
        this.getLog().info((CharSequence)(" - adding license header on file " + file));
        content = this.getTransformer().addHeader(this.getFilter().getFullHeaderContent(), content);
        if (!this.isDryRun()) {
            this.writeFile(processFile, content, this.getEncoding());
        }
        FileState.add.addFile(file, this.getResult());
        return true;
    }

    protected void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = this.getBackupFile(file);
            if (backupFile.exists()) {
                this.deleteFile(backupFile);
            }
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)(" - backup original file " + file));
            }
            this.renameFile(file, backupFile);
        }
        if (this.isDryRun()) {
            this.deleteFile(processFile);
        } else {
            this.renameFile(processFile, file);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    protected void clear() {
        EnumMap<FileState, Set<File>> result;
        Set<File> files = this.getProcessedFiles();
        if (files != null) {
            files.clear();
        }
        if ((result = this.getResult()) != null) {
            for (Set<File> fileSet : result.values()) {
                fileSet.clear();
            }
            result.clear();
        }
    }

    protected void reportType(FileState state, StringBuilder buffer) {
        String operation = state.name();
        Set<File> set = this.getFiles(state);
        if (set == null || set.isEmpty()) {
            if (this.isVerbose()) {
                buffer.append("\n * no header to ");
                buffer.append(operation);
                buffer.append(".");
            }
            return;
        }
        buffer.append("\n * ").append(operation).append(" header on ");
        buffer.append(set.size());
        if (set.size() == 1) {
            buffer.append(" file.");
        } else {
            buffer.append(" files.");
        }
        if (this.isVerbose()) {
            for (File file : set) {
                buffer.append("\n   - ").append(file);
            }
        }
    }

    public boolean isClearAfterOperation() {
        return this.clearAfterOperation;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getInceptionYear() {
        return this.inceptionYear;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public boolean isUpdateCopyright() {
        return this.updateCopyright;
    }

    public String getIgnoreTag() {
        return this.ignoreTag;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public UpdateFileHeaderFilter getFilter() {
        return this.filter;
    }

    @Override
    public FileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public FileHeaderTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isSkip() {
        return this.skipUpdateLicense;
    }

    public Set<File> getProcessedFiles() {
        return this.processedFiles;
    }

    public EnumMap<FileState, Set<File>> getResult() {
        return this.result;
    }

    public Set<File> getFiles(FileState state) {
        return this.result.get((Object)state);
    }

    public boolean isAddSvnKeyWords() {
        return this.addSvnKeyWords;
    }

    public FileHeaderProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void setSkip(boolean skipUpdateLicense) {
        this.skipUpdateLicense = skipUpdateLicense;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setSkipUpdateLicense(boolean skipUpdateLicense) {
        this.skipUpdateLicense = skipUpdateLicense;
    }

    public void setInceptionYear(String inceptionYear) {
        this.inceptionYear = inceptionYear;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setUpdateCopyright(boolean updateCopyright) {
        this.updateCopyright = updateCopyright;
    }

    public void setIgnoreTag(String ignoreTag) {
        this.ignoreTag = ignoreTag;
    }

    public void setAddSvnKeyWords(boolean addSvnKeyWords) {
        this.addSvnKeyWords = addSvnKeyWords;
    }

    public void setClearAfterOperation(boolean clearAfterOperation) {
        this.clearAfterOperation = clearAfterOperation;
    }

    public void setTransformer(FileHeaderTransformer transformer) {
        this.transformer = transformer;
    }

    public void setHeader(FileHeader header) {
        this.header = header;
    }

    public void setProcessor(FileHeaderProcessor processor) {
        this.processor = processor;
    }

    public void setFilter(UpdateFileHeaderFilter filter) {
        this.filter = filter;
    }

    static enum FileState {
        update,
        uptodate,
        add,
        ignore,
        fail;


        public void addFile(File file, EnumMap<FileState, Set<File>> result) {
            Set<File> fileSet = result.get((Object)this);
            if (fileSet == null) {
                fileSet = new HashSet<File>();
                result.put(this, fileSet);
            }
            fileSet.add(file);
        }
    }
}

