/*
 * #%L
 * Maven License Plugin
 * 
 * $Author$
 * $LastChangedDate: 2010-04-12 13:01:09 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 1737 $
 * $Id: UpdateFileHeaderFilter.java 1737 2010-04-12 11:01:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/header/UpdateFileHeaderFilter.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin.header;

import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

/**
 * Implementation of {@link FileHeaderFilter} to update an incoming header.
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.license.plugin.header.FileHeaderFilter" role-hint="update-file-header"
 * @since 2.1
 */
public class UpdateFileHeaderFilter extends FileHeaderFilter {

    protected boolean updateCopyright;

    public UpdateFileHeaderFilter() {
    }

    @Override
    protected String treateHeader(String ch) {

        if (getLog().isDebugEnabled()) {
            getLog().debug("header\n" + ch);
        }

        FileHeaderTransformer transformer = getTransformer();

        // unbox comment
        String unbox = transformer.unboxComent(ch);

        if (getLog().isDebugEnabled()) {
            getLog().info("unboxed comment header\n" + unbox);
        }

        // obtain current license of file
        FileHeader fileHeader = transformer.toFileHeader(unbox);

        // updates license
        fileHeader.setLicense(getFileHeader().getLicense());

        if (isUpdateCopyright()) {
            // 1) obtain the svn last comit on this file

            // 2) compute the last year of copyright

            // 3) if necessary update last year
            //fileHeader.setCopyrightLastYear(lastYear);
        }
        // build new brut header (with no boxing)
        String newHeader = transformer.toString(fileHeader);

        // box with process tag
        newHeader = transformer.boxProcessTag(newHeader);

        // box header with comment prefix
        newHeader = transformer.boxComment(newHeader, false);

        // remove all before process start tag
        // remove all after process end tag
        // this is a requirement for processor to respect involution.
        int index = newHeader.indexOf(transformer.getProcessStartTag());
        int lastIndex =
                newHeader.lastIndexOf(transformer.getProcessEndTag()) +
                transformer.getProcessEndTag().length();

        String result = newHeader.substring(index, lastIndex);

        if (getLog().isDebugEnabled()) {
            getLog().debug("updated Header =\n" + result);
        }
        return result;
    }

    public boolean isUpdateCopyright() {
        return updateCopyright;
    }

    public void setUpdateCopyright(boolean updateCopyright) {
        this.updateCopyright = updateCopyright;
    }
}
