/*
 * #%L
 * Maven License Plugin
 * 
 * $Author$
 * $LastChangedDate: 2010-04-12 13:01:09 +0200 (lun., 12 avril 2010) $
 * $LastChangedRevision: 1737 $
 * $Id: FileHeaderProcessorConfiguration.java 1737 2010-04-12 11:01:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/header/FileHeaderProcessorConfiguration.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin.header;

import org.apache.maven.plugin.logging.Log;
import org.nuiton.license.plugin.header.transformer.FileHeaderTransformer;

/**
 * Contract of required configuration of the {@link FileHeaderProcessor}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.1
 */
public interface FileHeaderProcessorConfiguration {

    /** @return mojo logger */
    Log getLog();

    /** @return the current file header to use */
    FileHeader getFileHeader();

    /** @return the current file transformer to use */
    FileHeaderTransformer getTransformer();

}
