/*
 * #%L
 * Maven License Plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:45:56 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 1735 $
 * $Id: GeneratorListMojo.java 1735 2010-04-10 20:45:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/GeneratorListMojo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.license.plugin.header.generator.HeaderGenerator;

import java.util.Map;
import java.util.Map.Entry;

/**
 * Displays all the available generators.
 *
 * @author tchemit <chemit@codelutin.com>
 * @requiresProject false
 * @requiresDirectInvocation
 * @goal generator-list
 * @since 1.0.1
 * @deprecated since 2.1, use now the {@code comment(style-list} goal.
 */
@Deprecated
public class GeneratorListMojo extends AbstractLicenseMojo {

    /**
     * Un drapeau pour afficher aussi le contenu des license.
     *
     * @parameter expression="${detail}"
     * @since 1.0.1
     */
    protected boolean detail;

    /**
     * All available generators
     *
     * @component role="org.nuiton.license.header.generator.HeaderGenerator"
     */
    protected Map<String, HeaderGenerator> _generators;

    @Override
    protected void init() throws Exception {
        // nothing to do
    }

    @Override
    public void doAction() throws MojoExecutionException, MojoFailureException {

        // display it
        StringBuilder buffer = new StringBuilder("\n");
        buffer.append("\n\n-------------------------------------------------------------------------------\n");
        buffer.append("                           maven-license-plugin\n");
        buffer.append("-------------------------------------------------------------------------------\n\n");
        if (_generators == null || _generators.isEmpty()) {
            buffer.append("No generator found.\n\n");
        } else {
            buffer.append("List of available generators :\n\n");
            for (Entry<String, HeaderGenerator> e : _generators.entrySet()) {
                HeaderGenerator generator = e.getValue();
                buffer.append("  - ");
                buffer.append(e.getKey());
                buffer.append(" : ");
                buffer.append(generator.getDescription());
                buffer.append("\n");
                if (detail) {
                    buffer.append("\n   example : \n");
                    buffer.append(generator.getHeader("content "));
                    buffer.append('\n');
                }
            }
        }
        getLog().info(buffer.toString());
    }
}
