/*
 * #%L
 * Maven License Plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:45:56 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 1735 $
 * $Id: AbstractLicenseMojo.java 1735 2010-04-10 20:45:56Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-license-plugin/tags/maven-license-plugin-2.1/src/main/java/org/nuiton/license/plugin/AbstractLicenseMojo.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.license.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuiton.license.plugin.model.LicenseStore;
import org.nuiton.plugin.AbstractPlugin;

import java.io.IOException;

/**
 * Abstract license mojo.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.1
 */
public abstract class AbstractLicenseMojo extends AbstractPlugin {

    /**
     * Dependance du projet.
     *
     * @parameter default-value="${project}"
     * @required
     * @since 2.1
     */
    private MavenProject project;

    /**
     * Un flag pour activer le mode verbeux.
     *
     * @parameter expression="${license.verbose}"  default-value="${maven.verbose}"
     * @since 2.1
     */
    private boolean verbose;

    /**
     * Encoding a utiliser pour lire et ecrire les fichiers.
     *
     * @parameter expression="${license.encoding}" default-value="${project.build.sourceEncoding}"
     * @required
     * @since 2.1
     */
    private String encoding;

    @Override
    public final MavenProject getProject() {
        return project;
    }

    @Override
    public final void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public final boolean isVerbose() {
        return verbose;
    }

    @Override
    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final String getEncoding() {
        return encoding;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected LicenseStore createLicenseStore(String... extraResolver)
            throws MojoExecutionException {
        LicenseStore store;
        try {
            store = new LicenseStore();
            store.addJarRepository();
            if (extraResolver != null) {
                for (String s : extraResolver) {
                    if (s != null && !s.trim().isEmpty()) {
                        getLog().info("adding extra resolver " + s);
                        store.addRepository(s);
                    }
                }
            }
            store.init();
        } catch (IllegalArgumentException ex) {
            throw new MojoExecutionException(
                    "could not obtain the license repository", ex);
        } catch (IOException ex) {
            throw new MojoExecutionException(
                    "could not obtain the license repository", ex);
        }
        return store;
    }

    protected boolean hasClassPath() {
        return rejectPackaging(Packaging.pom);
    }

}
