/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.nuiton.license.plugin.header.generator.HeaderGenerator;
import org.nuiton.license.plugin.repository.License;
import org.nuiton.license.plugin.repository.LicenseRepository;
import org.nuiton.license.plugin.repository.LicenseRepositoryFactory;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.processor.LicenseProcessor;

public class UpdateHeaderMojo
extends AbstractPlugin {
    protected MavenProject project;
    protected String encoding;
    protected String inceptionYear;
    protected String organizationName;
    protected String projectName;
    protected String licenseName;
    protected String generatorName;
    protected String includes = "**/*.java";
    protected String excludes;
    protected List<String> compileSourceRoots;
    protected List<String> testSourceRoots;
    protected String licenseResolver;
    protected String template;
    protected Map<String, String> templateParameters;
    protected boolean keepBackup;
    protected boolean verbose;
    protected boolean skipUpdateHeader;
    protected boolean dryRun;
    protected VelocityComponent velocity;
    protected Map<String, HeaderGenerator> _generators;
    protected String licenseHeaderContent;
    protected String boxedLicenseHeaderContent;
    protected Map<File, String[]> filesToTreate;
    protected long timestamp;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean checkPackaging() {
        return true;
    }

    public void setCompileSourceRoots(String root) {
        String[] roots = PluginHelper.splitAndTrim((String)root, (String)",");
        this.setCompileSourceRoots(Arrays.asList(roots));
    }

    public void setCompileSourceRoots(List<String> compileSourceRoots) {
        this.compileSourceRoots = compileSourceRoots;
    }

    public void setTestSourceRoots(String root) {
        String[] roots = PluginHelper.splitAndTrim((String)root, (String)",");
        this.setTestSourceRoots(Arrays.asList(roots));
    }

    public void setTestSourceRoots(List<String> testSourceRoots) {
        this.testSourceRoots = testSourceRoots;
    }

    protected boolean checkSkip() {
        if (this.skipUpdateHeader) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return false;
        }
        if (this.filesToTreate == null || this.filesToTreate.isEmpty()) {
            this.getLog().info((CharSequence)"No file to treate, will skip goal.");
            return false;
        }
        return super.checkSkip();
    }

    public void init() throws Exception {
        if (this.skipUpdateHeader) {
            return;
        }
        this.timestamp = System.nanoTime();
        if (this._generators == null) {
            throw new MojoExecutionException("no header generator found");
        }
        if (this.verbose) {
            Iterator<Object> i$ = this._generators.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, HeaderGenerator> stringHeaderGeneratorEntry;
                Map.Entry<String, HeaderGenerator> next = stringHeaderGeneratorEntry = i$.next();
                this.getLog().info((CharSequence)("config - available generator : " + next.getKey()));
            }
            if (this.compileSourceRoots != null) {
                for (String root : this.compileSourceRoots) {
                    this.getLog().info((CharSequence)("config - compile source root : " + root));
                }
            }
            if (this.testSourceRoots != null) {
                for (String root : this.testSourceRoots) {
                    this.getLog().info((CharSequence)("config - test source root : " + root));
                }
            }
        }
        if (!this._generators.containsKey(this.generatorName.trim())) {
            throw new MojoExecutionException("the generator named '" + this.generatorName + "' is unknown (use generator-list goal to see all of them)");
        }
        HeaderGenerator generator = this._generators.get(this.generatorName);
        this.filesToTreate = new HashMap<File, String[]>();
        String[] in = this.includes.split(",");
        String[] ex = this.excludes == null ? null : this.excludes.split(",");
        this.getFilesToTreateForRoots(in, ex, this.compileSourceRoots, this.filesToTreate, null);
        this.getFilesToTreateForRoots(in, ex, this.testSourceRoots, this.filesToTreate, null);
        if (this.filesToTreate.isEmpty()) {
            return;
        }
        File templateFile = new File(this.template);
        this.checkResource(templateFile);
        LicenseRepository factory = LicenseRepositoryFactory.newLicenseRepository(true, true, this.licenseResolver);
        License license = factory.getLicense(this.licenseName);
        if (this.verbose) {
            this.getLog().info((CharSequence)("config - use license " + license.getName()));
            this.getLog().info((CharSequence)("config - use generator " + generator.getName()));
            this.getLog().info((CharSequence)("config - use template " + this.template));
        }
        this.licenseHeaderContent = this.computeHeader(license, generator);
        this.boxedLicenseHeaderContent = generator.getHeader(this.licenseHeaderContent);
        if (this.verbose) {
            this.getLog().info((CharSequence)("config - header to use\n" + this.boxedLicenseHeaderContent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction() throws Exception {
        LicenseProcessor p = new LicenseProcessor(this.licenseHeaderContent);
        for (Map.Entry<File, String[]> entry : this.filesToTreate.entrySet()) {
            File src = entry.getKey();
            for (String javaRelativePath : entry.getValue()) {
                File file = new File(src, javaRelativePath);
                if (this.verbose) {
                    this.getLog().info((CharSequence)("process file " + file));
                }
                File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
                try {
                    p.process(file, processFile);
                    boolean foundLicenseHeader = p.getLicenceFilter().wasTouched();
                    if (!foundLicenseHeader) {
                        if (p.getLicenceFilter().isDetectHeader()) {
                            this.getLog().warn((CharSequence)("skip file " + file + " (no license footer tag found : '##%*' !)"));
                        } else {
                            this.getLog().info((CharSequence)("adding license header on file " + file));
                            String content = PluginHelper.readAsString((File)file, (String)this.encoding);
                            content = this.boxedLicenseHeaderContent + content;
                            if (!this.dryRun) {
                                this.writeFile(processFile, content, this.encoding);
                            }
                        }
                    }
                    if (this.keepBackup && !this.dryRun) {
                        File backupFile = new File(file.getAbsolutePath() + "~");
                        if (this.verbose) {
                            this.getLog().debug((CharSequence)("backup original file " + file));
                        }
                        this.renameFile(file, backupFile);
                    }
                    if (this.dryRun) {
                        this.deleteFile(processFile);
                        continue;
                    }
                    this.renameFile(processFile, file);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("skip file " + file + " (could not process for reason : " + e.getMessage() + ")"));
                    this.deleteFile(processFile);
                }
                finally {
                    p.getLicenceFilter().reset();
                }
            }
        }
    }

    protected String computeHeader(License license, HeaderGenerator generator) throws Exception {
        String licenseContent = license.getHeaderContent(this.encoding);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        String thisYear = cal.get(1) + "";
        if (!thisYear.equals(this.inceptionYear)) {
            this.inceptionYear = this.inceptionYear + " - " + thisYear;
        }
        VelocityContext context = new VelocityContext();
        context.put("inceptionYear", (Object)this.inceptionYear);
        context.put("projectName", (Object)this.projectName);
        context.put("organizationName", (Object)this.organizationName);
        context.put("licenseContent", (Object)licenseContent);
        if (this.templateParameters != null) {
            for (Map.Entry<String, String> e : this.templateParameters.entrySet()) {
                context.put(e.getKey(), (Object)e.getValue());
            }
        }
        if (this.verbose) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - parameters for template : ");
            for (Object key : context.getKeys()) {
                buffer.append("\n   * ").append(key).append(" : ").append(context.get(key + ""));
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        VelocityEngine engine = this.velocity.getEngine();
        StringWriter writer = new StringWriter();
        Template velocityTemplate = engine.getTemplate(this.template, this.encoding);
        velocityTemplate.merge((Context)context, (Writer)writer);
        writer.flush();
        writer.close();
        String r = writer.getBuffer().toString();
        String result = generator.prefixContent(r.trim() + "\n\n");
        return '\n' + result;
    }
}

