/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton:maven-license-plugin:2.0.2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven License Plugin", 0);
        this.append(sb, "Plugin pour mettre \u00e0 jour l'en-t\u00eate des fichiers (avec la license choisie) dans un module maven 2.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-license".equals(this.goal)) {
            this.append(sb, "license:add-license", 0);
            this.append(sb, "Le goal pour ajouter le fichier LICENSE.txt dans le classpath (et le generer s'il n'existe pas).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "copyToMETA_INF (Default: false)", 2);
                this.append(sb, "Un flag pour faire une copie nomm\u00e9e dans META-INF (prefixe avec le nom de l'artifact).\nCette option n'est utilisable que sur des modules avec un class-path (pas pour un pom)\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "La baseURL d'un resolver de license supplementaire", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Un flag pour forcer la generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "Un flag pour conserver un backup des fichiers modifies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseFile (Default: ${basedir}/LICENSE.txt)", 2);
                this.append(sb, "Fichier de la licence du module.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseFilename", 2);
                this.append(sb, "Repertoire de sortie des classes (classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Le type de license a appliquer.\nPour obtenir la liste des licenses disponibles, utilisez le goal available-licenses\n\n\u00a0mvn\u00a0helper:available-licenses\u00a0-Ddetail\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "Repertoire de sortie des sources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "Dependance du projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-third-party".equals(this.goal)) {
            this.append(sb, "license:add-third-party", 0);
            this.append(sb, "Le goal pour copier le fichier THIRD-PARTY.txt (contenant les licenses de toutes les dependances du projet) dans le classpath (et le generer s'il n'existe pas).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "copyToMETA_INF (Default: false)", 2);
                this.append(sb, "Un flag pour faire une copie nomm\u00e9 dans META-INF (prefixe avec le nom de l'artifact).", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "Un flag pour forcer la generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "Un flag pour conserver un backup des fichiers modifies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "Repertoire de sortie des classes (classpath).", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2);
                this.append(sb, "Fichier ou ecrire les licences des dependances.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generator-list".equals(this.goal)) {
            this.append(sb, "license:generator-list", 0);
            this.append(sb, "Displays all the available generators.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "Un drapeau pour afficher aussi le contenu des license.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "license:help", 0);
            this.append(sb, "Display help information on maven-license-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "license-list".equals(this.goal)) {
            this.append(sb, "license:license-list", 0);
            this.append(sb, "Display all available licenses.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "Un drapeau pour afficher aussi le contenu des license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: UTF-8)", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "La baseURL d'un resolver de license supplementaire", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-header".equals(this.goal)) {
            this.append(sb, "license:update-header", 0);
            this.append(sb, "The goal to update (or add) the licence header on some files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compileSourceRoots (Default: ${project.compileSourceRoots})", 2);
                this.append(sb, "Compile source directory roots to inspect. Can use it a a comma separated string :\n<compileSourceRoots>src/site,src.target/extra-site</compileSourceRoots>\nor a list :\n\u00a0\u00a0<compileSourceRoots>\n\u00a0\u00a0\u00a0\u00a0<root>src/site</root>\n<root>src/target/extra-site</root> </compileSourceRoots> Note: If not set, will use the build compile roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "A flag to test plugin but modify no file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "La liste des patterns de fichiers \u00e0 exclure (s\u00e9par\u00e9s par des virgules).\nExemple : **\\/*.java,**\\/*.properties\n\nOn recherchera alors les fichiers respectant l'un des patterns dans tous les r\u00e9pertoires de sources et de tests.\n\nPar d\u00e9faut, on n'exclue rien.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatorName (Default: license-java)", 2);
                this.append(sb, "Le type de g\u00e9n\u00e9rateur a utiliser pour encapsuler le header.\nPar d\u00e9faut, on veut utiliser le plugin sur des fichiers sources java.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "inceptionYear (Default: ${project.inceptionYear})", 2);
                this.append(sb, "l'annee de creation du module (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **/*.java)", 2);
                this.append(sb, "La liste des patterns de fichiers \u00e0 inclure (s\u00e9par\u00e9s par des virgules).\nExemple : **\\/*.java,**\\/*.properties\n\nOn recherchera alors les fichiers respectant l'un des patterns dans tous les r\u00e9pertoires de sources et de tests.\n\nPar d\u00e9faut, on veut utiliser le plugin sur des fichiers sources java.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "Un flag pour conserver un backup des fichiers modifies.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Le type de license a appliquer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseResolver", 2);
                this.append(sb, "Un resolver externe", 3);
                this.append(sb, "", 0);
                this.append(sb, "organizationName (Default: ${project.organization.name})", 2);
                this.append(sb, "le nom de l'organisation (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "Dependance du projet.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.name})", 2);
                this.append(sb, "le nom du projet (sera place dans le header)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUpdateHeader (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template (Default: /license/defaultHeader.vm)", 2);
                this.append(sb, "La template (velocity) a utiliser pour construire le header.\nCette template doit \u00eatre dans le class-path ou \u00eatre un fichier existant\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateParameters", 2);
                this.append(sb, "Des param\u00e8tres suppl\u00e9mentaires \u00e0 utiliser dans la template du header.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceRoots (Default: ${project.testCompileSourceRoots})", 2);
                this.append(sb, "Test source directory roots to inspect. Can use it a a comma separated string :\n<testSourceRoots>src/test1,src/test2</testSourceRoots>\nor a list :\n\u00a0\u00a0<testSourceRoots>\n\u00a0\u00a0\u00a0\u00a0<root>src/site</root>\n<root>src/target/extra-site</root> </testSourceRoots> Note: If not set, will use the build test roots.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Un flag pour activer le mode verbeux.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

