package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-license-plugin.<br/> Call <pre>  mvn license:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Jan 21 13:54:45 CET 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.5.1)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.nuiton:maven-license-plugin:2.0.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven License Plugin", 0 );
        append( sb, "Plugin pour mettre \u00e0 jour l\'en-t\u00eate des fichiers (avec la license choisie) dans un module maven 2.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "add-license".equals( goal ) )
        {
            append( sb, "license:add-license", 0 );
            append( sb, "Le goal pour ajouter le fichier LICENSE.txt dans le classpath (et le generer s\'il n\'existe pas).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "copyToMETA_INF (Default: false)", 2 );
                append( sb, "Un flag pour faire une copie nomm\u00e9e dans META-INF (prefixe avec le nom de l\'artifact).\nCette option n\'est utilisable que sur des modules avec un class-path (pas pour un pom)\n", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3 );
                append( sb, "", 0 );

                append( sb, "extraResolver", 2 );
                append( sb, "La baseURL d\'un resolver de license supplementaire", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Un flag pour forcer la generation.", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "Un flag pour conserver un backup des fichiers modifies.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseFile (Default: ${basedir}/LICENSE.txt)", 2 );
                append( sb, "Fichier de la licence du module.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseFilename", 2 );
                append( sb, "Repertoire de sortie des classes (classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "licenseName", 2 );
                append( sb, "Le type de license a appliquer.\nPour obtenir la liste des licenses disponibles, utilisez le goal available-licenses\n\n\u00a0mvn\u00a0helper:available-licenses\u00a0-Ddetail\n", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources/license)", 2 );
                append( sb, "Repertoire de sortie des sources.", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "add-third-party".equals( goal ) )
        {
            append( sb, "license:add-third-party", 0 );
            append( sb, "Le goal pour copier le fichier THIRD-PARTY.txt (contenant les licenses de toutes les dependances du projet) dans le classpath (et le generer s\'il n\'existe pas).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "copyToMETA_INF (Default: false)", 2 );
                append( sb, "Un flag pour faire une copie nomm\u00e9 dans META-INF (prefixe avec le nom de l\'artifact).", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3 );
                append( sb, "", 0 );

                append( sb, "force (Default: false)", 2 );
                append( sb, "Un flag pour forcer la generation.", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "Un flag pour conserver un backup des fichiers modifies.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: target/generated-sources/license)", 2 );
                append( sb, "Repertoire de sortie des classes (classpath).", 3 );
                append( sb, "", 0 );

                append( sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2 );
                append( sb, "Fichier ou ecrire les licences des dependances.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generator-list".equals( goal ) )
        {
            append( sb, "license:generator-list", 0 );
            append( sb, "Displays all the available generators.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail", 2 );
                append( sb, "Un drapeau pour afficher aussi le contenu des license.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "license:help", 0 );
            append( sb, "Display help information on maven-license-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "license-list".equals( goal ) )
        {
            append( sb, "license:license-list", 0 );
            append( sb, "Display all available licenses.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail", 2 );
                append( sb, "Un drapeau pour afficher aussi le contenu des license.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: UTF-8)", 2 );
                append( sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3 );
                append( sb, "", 0 );

                append( sb, "extraResolver", 2 );
                append( sb, "La baseURL d\'un resolver de license supplementaire", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-header".equals( goal ) )
        {
            append( sb, "license:update-header", 0 );
            append( sb, "The goal to update (or add) the licence header on some files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "compileSourceRoots (Default: ${project.compileSourceRoots})", 2 );
                append( sb, "Repertoires des fichiers sources a traiter.", 3 );
                append( sb, "", 0 );

                append( sb, "dryRun (Default: false)", 2 );
                append( sb, "A flag to test plugin but modify no file.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding a utiliser pour lire et ecrire les fichiers.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "La liste des patterns de fichiers \u00e0 exclure (s\u00e9par\u00e9s par des virgules).\nExemple : **\\/*.java,**\\/*.properties\n\nOn recherchera alors les fichiers respectant l\'un des patterns dans tous les r\u00e9pertoires de sources et de tests.\n\nPar d\u00e9faut, on n\'exclue rien.\n", 3 );
                append( sb, "", 0 );

                append( sb, "generatorName (Default: license-java)", 2 );
                append( sb, "Le type de g\u00e9n\u00e9rateur a utiliser pour encapsuler le header.\nPar d\u00e9faut, on veut utiliser le plugin sur des fichiers sources java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "inceptionYear (Default: ${project.inceptionYear})", 2 );
                append( sb, "l\'annee de creation du module (sera place dans le header)", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*.java)", 2 );
                append( sb, "La liste des patterns de fichiers \u00e0 inclure (s\u00e9par\u00e9s par des virgules).\nExemple : **\\/*.java,**\\/*.properties\n\nOn recherchera alors les fichiers respectant l\'un des patterns dans tous les r\u00e9pertoires de sources et de tests.\n\nPar d\u00e9faut, on veut utiliser le plugin sur des fichiers sources java.\n", 3 );
                append( sb, "", 0 );

                append( sb, "keepBackup (Default: false)", 2 );
                append( sb, "Un flag pour conserver un backup des fichiers modifies.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseName", 2 );
                append( sb, "Le type de license a appliquer.", 3 );
                append( sb, "", 0 );

                append( sb, "licenseResolver", 2 );
                append( sb, "Un resolver externe", 3 );
                append( sb, "", 0 );

                append( sb, "organizationName (Default: ${project.organization.name})", 2 );
                append( sb, "le nom de l\'organisation (sera place dans le header)", 3 );
                append( sb, "", 0 );

                append( sb, "project (Default: ${project})", 2 );
                append( sb, "Dependance du projet.", 3 );
                append( sb, "", 0 );

                append( sb, "projectName (Default: ${project.name})", 2 );
                append( sb, "le nom du projet (sera place dans le header)", 3 );
                append( sb, "", 0 );

                append( sb, "skipUpdateHeader (Default: false)", 2 );
                append( sb, "A flag to skip the goal.", 3 );
                append( sb, "", 0 );

                append( sb, "template (Default: /license/defaultHeader.vm)", 2 );
                append( sb, "La template (velocity) a utiliser pour construire le header.\nCette template doit \u00eatre dans le class-path ou \u00eatre un fichier existant\n", 3 );
                append( sb, "", 0 );

                append( sb, "templateParameters", 2 );
                append( sb, "Des param\u00e8tres suppl\u00e9mentaires \u00e0 utiliser dans la template du header.", 3 );
                append( sb, "", 0 );

                append( sb, "testCompileSourceRoots (Default: ${project.testCompileSourceRoots})", 2 );
                append( sb, "Repertoires des fichiers sources de test a traiter.", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: ${maven.verbose})", 2 );
                append( sb, "Un flag pour activer le mode verbeux.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
