/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.math.matrix.AbstractMatrixND;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixProvider;

public class MatrixProxy
extends AbstractMatrixND {
    private static final long serialVersionUID = 2338394722090201478L;
    protected MatrixProvider matrixProvider;

    protected MatrixProxy(MatrixFactory factory, int[] dim) {
        super(factory, dim);
    }

    protected MatrixProxy(MatrixFactory factory, List<?>[] semantics) {
        super(factory, semantics);
    }

    protected MatrixProxy(MatrixFactory factory, String name, int[] dim) {
        super(factory, name, dim);
    }

    protected MatrixProxy(MatrixFactory factory, String name, int[] dim, String[] dimNames) {
        super(factory, name, dim, dimNames);
    }

    protected MatrixProxy(MatrixFactory factory, String name, List<?>[] semantics) {
        super(factory, name, semantics);
    }

    protected MatrixProxy(MatrixFactory factory, String name, List<?>[] semantics, String[] dimNames) {
        super(factory, name, semantics, dimNames);
    }

    @Override
    public int getNumberOfAssignedValue() {
        return 0;
    }

    public MatrixProvider getMatrixProvider() {
        return this.matrixProvider;
    }

    public void setMatrixProvider(MatrixProvider matrixProvider) {
        this.matrixProvider = matrixProvider;
    }

    @Override
    public MatrixIterator iterator() {
        throw new UnsupportedOperationException("Not implemented on matrix proxy");
    }

    @Override
    public MatrixIterator iteratorNotZero() {
        throw new UnsupportedOperationException("Not implemented on matrix proxy");
    }

    @Override
    public double getValue(int[] coordinates) {
        throw new UnsupportedOperationException("Not implemented on matrix proxy");
    }

    @Override
    public void setValue(int[] coordinates, double d) {
        throw new UnsupportedOperationException("Not implemented on matrix proxy");
    }

    @Override
    public MatrixND getSubMatrix(int dim, int start, int nb) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public MatrixND getSubMatrix(int dim, Object ... elem) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public MatrixND getSubMatrix(Object[] ... elems) {
        int[][] elemIndices = new int[elems.length][];
        for (int i = 0; i < elemIndices.length; ++i) {
            if (elems[i] == null) continue;
            elemIndices[i] = new int[elems[i].length];
            for (int j = 0; j < elems[i].length; ++j) {
                elemIndices[i][j] = MatrixHelper.indexOf(this.getSemantics(), i, elems[i][j]);
            }
        }
        MatrixND subMatrix = this.getSubMatrix(elemIndices);
        return subMatrix;
    }

    @Override
    public MatrixND getSubMatrix(int dim, int[] elem) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public MatrixND getSubMatrix(int[] ... elems) {
        if (elems.length != this.dim.length) {
            throw new IllegalArgumentException(String.format("Can't get sub matrix with different dimension count (expected: %d, got %d)", this.dim.length, elems.length));
        }
        List[] subSem = new List[elems.length];
        for (int iDim = 0; iDim < elems.length; ++iDim) {
            subSem[iDim] = new ArrayList();
            List<?> semantics = this.semantics[iDim];
            for (int iElem = 0; iElem < semantics.size(); ++iElem) {
                if (elems[iDim] != null && !ArrayUtils.contains((int[])elems[iDim], (int)iElem)) continue;
                subSem[iDim].add(semantics.get(iElem));
            }
        }
        MatrixND subMatrix = this.factory.create(this.name, subSem, this.dimNames);
        this.matrixProvider.fillValues(subMatrix);
        return subMatrix;
    }

    @Override
    public boolean equals(MatrixND mat) {
        boolean result = true;
        result = result && this.getName().equals(mat.getName());
        for (int i = 0; result && i < this.getDimCount(); ++i) {
            String dimName1 = this.getDimensionName(i);
            String dimName2 = mat.getDimensionName(i);
            result = ObjectUtils.equals((Object)dimName1, (Object)dimName2);
            List sem1 = this.getSemantic(i);
            List sem2 = mat.getSemantic(i);
            result = result && ObjectUtils.equals((Object)sem1, (Object)sem2);
        }
        return result;
    }
}

