/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixDimensionAction;
import org.nuiton.math.matrix.viewer.SumAllAction;

public class MatrixDimensionPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1919447532660452240L;
    private static Log log = LogFactory.getLog(MatrixDimensionPanel.class);
    protected MatrixND matrix;
    protected List<SubDimensionPanel> subPanelList;
    protected List<MatrixDimensionAction> matrixDimensionActions;

    public MatrixDimensionPanel() {
        this.setLayout(new GridLayout(0, 1));
        this.subPanelList = new ArrayList<SubDimensionPanel>();
        this.matrixDimensionActions = new ArrayList<MatrixDimensionAction>();
        this.matrixDimensionActions.add(new SumAllAction());
    }

    protected void addMatrixDimentionAction(MatrixDimensionAction matrixDimentionAction) {
        this.matrixDimensionActions.add(matrixDimentionAction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.matrix = (MatrixND)evt.getNewValue();
        this.buildDimensionPanel();
        this.validate();
        this.repaint();
    }

    public MatrixND getModifiedMatrix() {
        MatrixND reducedMatrix = this.createAndReduce(this.matrix);
        return reducedMatrix;
    }

    protected void buildDimensionPanel() {
        this.subPanelList.clear();
        this.removeAll();
        if (this.matrix != null) {
            int index = 0;
            for (List semantic : this.matrix.getSemantics()) {
                String dimensionName = I18n.t((String)this.matrix.getDimensionName(index), (Object[])new Object[0]);
                if (dimensionName == null || dimensionName.isEmpty()) {
                    dimensionName = I18n.t((String)"nuitonmatrix.viewer.dimnameindex", (Object[])new Object[]{index});
                }
                SubDimensionPanel dimPanel = new SubDimensionPanel(index, dimensionName, semantic);
                this.add(dimPanel);
                this.subPanelList.add(dimPanel);
                ++index;
            }
        }
    }

    protected MatrixND createAndReduce(MatrixND matrix) {
        SubDimensionPanel subDimPanel;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matrice before submatrix : " + matrix));
        }
        int[][] dimIndices = new int[this.subPanelList.size()][];
        for (int i = 0; i < this.subPanelList.size(); ++i) {
            subDimPanel = this.subPanelList.get(i);
            JList list = subDimPanel.getList();
            int[] indList = list.getSelectedIndices();
            if (indList.length == 0) {
                list.setSelectionInterval(0, list.getModel().getSize() - 1);
                indList = list.getSelectedIndices();
            }
            if (0 >= indList.length || indList.length >= matrix.getDim(i)) continue;
            dimIndices[i] = indList;
        }
        matrix = matrix.getSubMatrix((int[][])dimIndices);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matrix after submatrix : " + matrix));
        }
        for (int d = 0; d < this.subPanelList.size(); ++d) {
            subDimPanel = this.subPanelList.get(d);
            String dimName = matrix.getDimensionName(d);
            dimName = StringUtils.removeEnd((String)dimName, (String)"*");
            matrix.setDimensionName(d, dimName);
            if (subDimPanel.isSelected()) {
                matrix.setDimensionName(d, dimName + "*");
                matrix = subDimPanel.apply(matrix, d);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Matrix after sum on dim " + d + ": " + matrix));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matrix bebore reduce: " + matrix));
        }
        MatrixND result = matrix.reduce(2);
        return result;
    }

    public void initRenderering(List[] dimSelectedValues, int[] selectedActions) {
        SubDimensionPanel panel;
        int dimIndex;
        for (dimIndex = 0; dimIndex < dimSelectedValues.length; ++dimIndex) {
            List selectedValues = dimSelectedValues[dimIndex];
            if (selectedValues == null) continue;
            panel = this.subPanelList.get(dimIndex);
            panel.semList.clearSelection();
            for (Object value : selectedValues) {
                int index = panel.semantic.indexOf(value);
                panel.semList.addSelectionInterval(index, index);
            }
        }
        for (dimIndex = 0; dimIndex < selectedActions.length; ++dimIndex) {
            int actionIndices = selectedActions[dimIndex];
            panel = this.subPanelList.get(dimIndex);
            int buttonIndex = 0;
            Enumeration<AbstractButton> buttons = panel.buttonGroup.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (actionIndices == buttonIndex) {
                    button.setSelected(true);
                }
                ++buttonIndex;
            }
        }
    }

    public static class SemanticListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 4384624824457446070L;
        protected List<?> semantic;

        public SemanticListModel(List<?> semantic) {
            this.semantic = semantic;
        }

        @Override
        public int getSize() {
            return this.semantic.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.semantic.get(index);
        }
    }

    protected class SubDimensionPanel
    extends JPanel {
        private static final long serialVersionUID = 9170588695850504050L;
        protected int index;
        protected String semanticName;
        protected List<?> semantic;
        protected ButtonGroup buttonGroup;
        protected JList semList;

        public SubDimensionPanel(int index, String semanticName, List<?> semantic) {
            super(new GridBagLayout());
            this.buttonGroup = new ButtonGroup(){
                private static final long serialVersionUID = 8214289174634749701L;

                @Override
                public void setSelected(ButtonModel m, boolean b) {
                    if (b) {
                        super.setSelected(m, b);
                    } else {
                        this.clearSelection();
                    }
                }
            };
            this.index = index;
            this.semanticName = semanticName;
            this.semantic = semantic;
            this.renderSubPanel();
        }

        protected void renderSubPanel() {
            JLabel semName = new JLabel(this.semanticName);
            this.add((Component)semName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            int nbActionAdded = 0;
            for (MatrixDimensionAction matrixDimensionAction : MatrixDimensionPanel.this.matrixDimensionActions) {
                boolean addSumAll = matrixDimensionAction.canApply(this.index, this.semantic);
                if (!addSumAll) continue;
                JToggleButton sumAll = new JToggleButton(matrixDimensionAction.getIcon());
                sumAll.setSelectedIcon(matrixDimensionAction.getSelectedIcon());
                sumAll.setModel(new MatrixActionButtonModel(matrixDimensionAction));
                sumAll.setToolTipText(matrixDimensionAction.getDescription());
                this.add((Component)sumAll, new GridBagConstraints(1 + nbActionAdded, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.buttonGroup.add(sumAll);
                ++nbActionAdded;
            }
            this.semList = new JList();
            List<?> dimSemantic = this.semantic;
            SemanticListModel semModel = new SemanticListModel(dimSemantic);
            this.semList.setModel(semModel);
            this.add((Component)new JScrollPane(this.semList), new GridBagConstraints(0, 1, 1 + nbActionAdded, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        public JList getList() {
            return this.semList;
        }

        public boolean isSelected() {
            boolean result = false;
            MatrixActionButtonModel buttonModel = (MatrixActionButtonModel)this.buttonGroup.getSelection();
            if (buttonModel != null) {
                result = true;
            }
            return result;
        }

        public MatrixND apply(MatrixND matrix, int dim) {
            MatrixActionButtonModel buttonModel = (MatrixActionButtonModel)this.buttonGroup.getSelection();
            MatrixDimensionAction matrixAction = buttonModel.getMatrixAction();
            matrix = matrixAction.apply(matrix, dim);
            return matrix;
        }
    }

    protected static class MatrixActionButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = -5737246124430280412L;
        protected MatrixDimensionAction matrixAction;

        public MatrixActionButtonModel(MatrixDimensionAction matrixAction) {
            this.matrixAction = matrixAction;
        }

        public MatrixDimensionAction getMatrixAction() {
            return this.matrixAction;
        }
    }
}

