package org.nuiton.math.matrix.gui;

/*
 * #%L
 * NuitonMatrix :: Nuiton-matrix-gui
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class MatrixPanelEditor extends MatrixEditor implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DIMENSION_EDIT = "dimensionEdit";
    public static final String PROPERTY_DISPLAY_OPTIONS = "displayOptions";
    public static final String PROPERTY_LINEAR_MODEL = "linearModel";
    public static final String PROPERTY_LINEAR_MODEL_SHOW_DEFAULT = "linearModelShowDefault";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_EDIT_VISIBLE = "buttonEdit.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$TABLE0_VISIBLE = "$Table0.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUv28TMRR2QpM0KU1pqpZWFBFK2aoLUgckUkp/EUqVAiIMFVlwcia54tjG9rXXBfEn8CfAzoLExoQYmBlYEP8CQgysiOe7JNcLBy1qBifx+77P7332e6+/oZSS6OIu9jxLukw7HWJtre7s3G3skqbeIKopHaG5RMEnkUTJOhqx+/tKo0v1qqGXuvTSOu8Izgg7xC5XUU7pA0pUmxCt0fkoo6lUqdYPlz3hyp5qP6k41Zc/vidf2M9fJRHyBGSXh1KKR7HCSoaqKOnYGhXgpD1copi1IA3psBbkO2r21ilW6g7ukKfoGcpUUVpgCWIazR2/ZF/D53tCo/z8NoYjvJu2A6ArGi1w2bKYC/+Y1cG6bRaIWy3XsQLoPcwIDfBC+EppjTJtzGxKpEaL/yOwGbBCnRHqMILlNrcJ1WjcFG0ZI6w1zinBLEROHULW2nx/gzzGLtUmOh6iRm3wgymHM3PgQDBvO0pQfHBXaACogWhm/gFuUAKeTEfuUO3DjVh+zCCzfcJYUKm5nypumPwLJn+vy9jyNw12uk8ZV24nOH29TZpP1rin0WSE1NuP8god8CJKNJFiFHVWS8yU4IocCR0mYM+qJBhYkfNrTckpNVcWLTaljQGDJfZdudwH5hqu1oH9Gk1E0Gt+pKsr0bmIzdCEVtiEYZck6iglXdiGe6n/2bf3IRR07PRAxxpBP/prauLzu69vK702zcDZk7HQQ1MG2kdILuCFO+bosaBHXe3Q0jYW5TrKKkJhRPkjaDYmsVo3DMnBecHLNnRrE6s2SKQyX95/mHr06RRKVlCOcmxXsMHfRlndluACp7Ynbqz4GZ3eH4b1jMlNozQ8YQ5WovySjTUuNhxmg7/LHpgwG2NCP5NG9uPPidqblZ4RCUhs5q/w0IzUQ5R2mOk/f2J1h1HshBoRirg2D4dO3BhKmO+c6Lbeor9ejas0s+cop/vCrnmu+Sr7eZtf132ZmWPIDGnigV2FpaCIItbQt/BMyXK85oUjNc12xSy34hXmTqwwf2KFhWMprP7DW6PwGwehhpCiBwAA";
    private static final Log log = LogFactory.getLog(MatrixPanelEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonEdit;
    protected Boolean dimensionEdit;
    protected Boolean displayOptions;
    protected JScrollPane editArea;
    protected MatrixPanelEditorHandler handler;
    protected Boolean linearModel;
    protected Boolean linearModelShowDefault;
    protected JLabel matrixNameLabel;
    protected JCheckBox meanOptionCheckBox;
    protected JCheckBox sumOptionCheckBox;
    protected JTable table;
    protected JCheckBox transposeOptionCheckBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MatrixPanelEditor $MatrixEditor0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected MatrixND matrix;
    
    
    @Override
    public void setMatrix(MatrixND matrix) {
        this.matrix = matrix;
        getHandler().initEditor(this);
    }
    
    @Override
    public MatrixND getMatrix() {
        return matrix;
    }
    
    protected void $afterCompleteSetup() {
        getHandler().initEditor(this);
        /* ne fonctionne, pas doit être fait des que l'instance change, même si les
           deux matrices sont égales
        addPropertyChangeListener(PROPERTY_MATRIX, new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                getHandler().initEditor(MatrixPanelEditor.this);
            }
        });*/
    }
    
    @Override
    protected void fireEvent() {
        getHandler().fireEvent(this);
    }
    
    public void addMatrixPanelListener(MatrixPanelListener l) {
        getHandler().addMatrixPanelListener(l);
    }
    
    public void removeMatrixPanelListener(MatrixPanelListener l) {
        getHandler().removeMatrixPanelListener(l);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MatrixPanelEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
            setPreferredSize(new java.awt.Dimension(width, height));
            $initialize();
    }

    public MatrixPanelEditor(boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
            $initialize();
    }

    public MatrixPanelEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit);
            //this.matrix = m; doesn't work
            setMatrix(m);
            $initialize();
    }

    public MatrixPanelEditor() {
        $initialize();
    }

    public MatrixPanelEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonEdit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().modifyMatrixDimension(this);
    }

    public void doActionPerformed__on__meanOptionCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().initEditor(this);
    }

    public void doActionPerformed__on__sumOptionCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().initEditor(this);
    }

    public void doActionPerformed__on__transposeOptionCheckBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().initEditor(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonEdit() {
        return buttonEdit;
    }

    public Boolean getDimensionEdit() {
        return dimensionEdit;
    }

    public Boolean getDisplayOptions() {
        return displayOptions;
    }

    public JScrollPane getEditArea() {
        return editArea;
    }

    public MatrixPanelEditorHandler getHandler() {
        return handler;
    }

    public Boolean getLinearModel() {
        return linearModel;
    }

    public Boolean getLinearModelShowDefault() {
        return linearModelShowDefault;
    }

    public JLabel getMatrixNameLabel() {
        return matrixNameLabel;
    }

    public JCheckBox getMeanOptionCheckBox() {
        return meanOptionCheckBox;
    }

    public JCheckBox getSumOptionCheckBox() {
        return sumOptionCheckBox;
    }

    public JTable getTable() {
        return table;
    }

    public JCheckBox getTransposeOptionCheckBox() {
        return transposeOptionCheckBox;
    }

    public Boolean isDimensionEdit() {
        return dimensionEdit !=null && dimensionEdit;
    }

    public Boolean isDisplayOptions() {
        return displayOptions !=null && displayOptions;
    }

    public Boolean isLinearModel() {
        return linearModel !=null && linearModel;
    }

    public Boolean isLinearModelShowDefault() {
        return linearModelShowDefault !=null && linearModelShowDefault;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDimensionEdit(Boolean dimensionEdit) {
        Boolean oldValue = this.dimensionEdit;
        this.dimensionEdit = dimensionEdit;
        firePropertyChange(PROPERTY_DIMENSION_EDIT, oldValue, dimensionEdit);
    }

    public void setDisplayOptions(Boolean displayOptions) {
        Boolean oldValue = this.displayOptions;
        this.displayOptions = displayOptions;
        firePropertyChange(PROPERTY_DISPLAY_OPTIONS, oldValue, displayOptions);
    }

    public void setLinearModel(Boolean linearModel) {
        Boolean oldValue = this.linearModel;
        this.linearModel = linearModel;
        firePropertyChange(PROPERTY_LINEAR_MODEL, oldValue, linearModel);
    }

    public void setLinearModelShowDefault(Boolean linearModelShowDefault) {
        Boolean oldValue = this.linearModelShowDefault;
        this.linearModelShowDefault = linearModelShowDefault;
        firePropertyChange(PROPERTY_LINEAR_MODEL_SHOW_DEFAULT, oldValue, linearModelShowDefault);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditArea() {
        if (!allComponentsCreated) {
            return;
        }
        editArea.getViewport().add(table);
    }

    protected void createButtonEdit() {
        $objectMap.put("buttonEdit", buttonEdit = new JButton());
        
        buttonEdit.setName("buttonEdit");
        buttonEdit.setText(_("nuitonmatrix.create.matrix.button"));
        buttonEdit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonEdit"));
    }

    protected void createDimensionEdit() {
        $objectMap.put("dimensionEdit", dimensionEdit = false);
    }

    protected void createDisplayOptions() {
        $objectMap.put("displayOptions", displayOptions = false);
    }

    protected void createEditArea() {
        $objectMap.put("editArea", editArea = new JScrollPane());
        
        editArea.setName("editArea");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new MatrixPanelEditorHandler());
    }

    protected void createLinearModel() {
        $objectMap.put("linearModel", linearModel = false);
    }

    protected void createLinearModelShowDefault() {
        $objectMap.put("linearModelShowDefault", linearModelShowDefault = false);
    }

    protected void createMatrixNameLabel() {
        $objectMap.put("matrixNameLabel", matrixNameLabel = new JLabel());
        
        matrixNameLabel.setName("matrixNameLabel");
    }

    protected void createMeanOptionCheckBox() {
        $objectMap.put("meanOptionCheckBox", meanOptionCheckBox = new JCheckBox());
        
        meanOptionCheckBox.setName("meanOptionCheckBox");
        meanOptionCheckBox.setText(_("nuitonmatrix.gui.meanOption"));
        meanOptionCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__meanOptionCheckBox"));
    }

    protected void createSumOptionCheckBox() {
        $objectMap.put("sumOptionCheckBox", sumOptionCheckBox = new JCheckBox());
        
        sumOptionCheckBox.setName("sumOptionCheckBox");
        sumOptionCheckBox.setText(_("nuitonmatrix.gui.sumOption"));
        sumOptionCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__sumOptionCheckBox"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JTable());
        
        table.setName("table");
    }

    protected void createTransposeOptionCheckBox() {
        $objectMap.put("transposeOptionCheckBox", transposeOptionCheckBox = new JCheckBox());
        
        transposeOptionCheckBox.setName("transposeOptionCheckBox");
        transposeOptionCheckBox.setText(_("nuitonmatrix.gui.transposeOption"));
        transposeOptionCheckBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transposeOptionCheckBox"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $MatrixEditor0
        add($Table0, BorderLayout.NORTH);
        add(editArea, BorderLayout.CENTER);
        add(buttonEdit, BorderLayout.SOUTH);
        // inline complete setup of $Table0
        $Table0.add(matrixNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(sumOptionCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(meanOptionCheckBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transposeOptionCheckBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToEditArea();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$MatrixEditor0", $MatrixEditor0);
        createHandler();
        createLinearModel();
        createLinearModelShowDefault();
        createDimensionEdit();
        createDisplayOptions();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMatrixNameLabel();
        createSumOptionCheckBox();
        createMeanOptionCheckBox();
        createTransposeOptionCheckBox();
        createEditArea();
        createTable();
        createButtonEdit();
        // inline creation of $MatrixEditor0
        setName("$MatrixEditor0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$TABLE0_VISIBLE, true ,"displayOptions") {
        
            @Override
            public void processDataBinding() {
                $Table0.setVisible(isDisplayOptions());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_EDIT_VISIBLE, true ,"dimensionEdit") {
        
            @Override
            public void processDataBinding() {
                buttonEdit.setVisible(isDimensionEdit());
            }
        });
    }

}