/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGeneratorConfiguration;
import org.nuiton.plugin.PluginHelper;

public class AnnouncementGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ATTACHMENT_TOKEN = "%FILE%";
    private final AnnouncementGeneratorConfiguration configuration;

    public AnnouncementGenerator(AnnouncementGeneratorConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAttachmentLinkTemplate() {
        return this.configuration.getAttachmentLinkTemplate();
    }

    public Log getLog() {
        return this.configuration.getLog();
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public Map<Attachment, String> getAttachmentsUrls(Attachment[] attachments) {
        boolean hasAttachmentLinks = this.canGenerateAttachmentLinks();
        HashMap<Attachment, String> urls = null;
        if (hasAttachmentLinks) {
            urls = new HashMap<Attachment, String>();
            for (Attachment a : attachments) {
                String u = this.parseAttachmentLink(a.getId() + "");
                urls.put(a, u);
            }
        } else {
            this.getLog().warn((CharSequence)"can not render attachments urls");
        }
        return urls;
    }

    public Context createVelocityContext(List<?> releases) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("releases", releases);
        context.put("groupId", (Object)this.configuration.getGroupId());
        context.put("artifactId", (Object)this.configuration.getArtifactId());
        context.put("version", (Object)this.configuration.getVersionId());
        context.put("packaging", (Object)this.configuration.getPackaging());
        context.put("url", (Object)this.configuration.getUrl());
        context.put("projectUrl", (Object)this.configuration.getProjectUrl());
        Release release = this.getLatestRelease(releases, this.configuration.getVersionId());
        context.put("release", (Object)release);
        context.put("introduction", (Object)this.configuration.getIntroduction());
        context.put("developmentTeam", (Object)this.configuration.getDevelopmentTeam());
        context.put("finalName", (Object)this.configuration.getFinalName());
        context.put("urlDownload", (Object)this.configuration.getUrlDownload());
        context.put("mavenRepoUrl", (Object)this.configuration.getDeploymentUrl());
        context.put("project", (Object)this.configuration.getProject());
        Map<File, String> artifactUrls = this.configuration.getArtifactUrls();
        if (artifactUrls == null || artifactUrls.isEmpty()) {
            context.put("withArtifacts", (Object)false);
        } else {
            context.put("withArtifacts", (Object)true);
            context.put("artifactUrls", artifactUrls);
        }
        Map<Attachment, String> attachmentUrls = this.configuration.getAttachmentUrls();
        if (attachmentUrls == null || attachmentUrls.isEmpty()) {
            context.put("withAttachments", (Object)false);
        } else {
            context.put("withAttachments", (Object)true);
            context.put("attachmentUrls", attachmentUrls);
        }
        Map<String, Object> announceParameters = this.configuration.getAnnounceParameters();
        if (announceParameters == null) {
            context.put("announceParameters", (Object)Collections.EMPTY_MAP);
        } else {
            context.put("announceParameters", announceParameters);
        }
        return context;
    }

    public void doGenerate(VelocityEngine engine, Context context, File out, String templatePath, String templateEncoding) throws MojoExecutionException {
        try {
            PluginHelper.createDirectoryIfNecessary((File)out.getParentFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), templateEncoding);
            Template velocityTemplate = engine.getTemplate(templatePath, templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    public boolean canGenerateAttachmentLinks() {
        String attachmentLinkTemplate = this.getAttachmentLinkTemplate();
        String url = this.getUrl();
        return !StringUtils.isBlank((String)attachmentLinkTemplate) && attachmentLinkTemplate.indexOf(ATTACHMENT_TOKEN) > 0 && (attachmentLinkTemplate.indexOf(URL_TOKEN) < 0 || !StringUtils.isBlank((String)url));
    }

    protected String parseAttachmentLink(String id) {
        String issueLink = this.getAttachmentLinkTemplate();
        String parseLink = issueLink.replaceFirst(ATTACHMENT_TOKEN, id);
        if (parseLink.indexOf(URL_TOKEN) >= 0) {
            parseLink = parseLink.replaceFirst(URL_TOKEN, this.getUrl());
        }
        return parseLink;
    }

    public Release getLatestRelease(List<?> releases, String releaseVersion) throws MojoExecutionException {
        boolean isFound;
        Release release;
        String pomVersion = releaseVersion;
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        for (Object release1 : releases) {
            release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(pomVersion)) continue;
            boolean isFound2 = true;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        release = this.getRelease(releases, pomVersion);
        boolean bl = isFound = release != null;
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    protected Release getRelease(List<?> releases, String version) {
        for (Object release1 : releases) {
            Release release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    private void logRelease(Release release) {
        for (Object o : release.getActions()) {
            Action action = (Action)o;
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
            this.getLog().debug((CharSequence)("dev : " + action.getDev()));
        }
    }
}

