/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.text.ParseException;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProjectAndVersion;
import org.nuiton.jredmine.plugin.DryRunAware;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="next-version", requiresOnline=true, requiresProject=true)
public class NextVersionMojo
extends AbstractRedmineMojoWithProjectAndVersion
implements DryRunAware {
    @Parameter(property="redmine.anonymous", defaultValue="false")
    protected boolean anonymous;
    @Parameter(property="redmine.versionDescription")
    protected String versionDescription;
    @Parameter(property="redmine.effectiveDate")
    protected String effectiveDate;
    @Parameter(property="redmine.previousVersionName")
    protected String previousVersionName;
    @Parameter(property="redmine.useLatestClosedVersion")
    protected boolean useLatestClosedVersion;
    @Parameter(property="redmine.skipNextVersion", defaultValue="false")
    protected boolean skipNextVersion;
    @Parameter(property="redmine.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;
    @Parameter(property="redmine.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    private Date date;
    protected boolean runOnceDone;

    public NextVersionMojo() {
        super(true, false);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public String getSkipProperty() {
        return "skipNextVersion";
    }

    @Override
    public boolean isGoalSkip() {
        return this.skipNextVersion;
    }

    @Override
    public boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    public boolean isRunOnlyOnRoot() {
        return this.runOnlyOnRoot;
    }

    @Override
    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    @Override
    public boolean checkRunOnceDone() {
        StringBuilder buffer = new StringBuilder("next-version");
        buffer.append("##").append(this.projectId);
        buffer.append("##").append(this.versionId);
        buffer.append("##").append(this.releaseVersion);
        buffer.append("##").append(this.versionDescription);
        buffer.append("##").append(this.previousVersionName);
        String key = buffer.toString();
        return !this.needInvoke(this.runOnce, this.runOnlyOnRoot, key);
    }

    @Override
    protected void init() throws Exception {
        if (this.isGoalSkip()) {
            return;
        }
        if (StringUtils.isBlank((String)this.versionId)) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        this.runOnceDone = this.isRunOnce() && this.checkRunOnceDone();
        if (this.runOnceDone) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.effectiveDate)) {
            try {
                this.date = this.dateFormat.parse(this.effectiveDate);
            }
            catch (ParseException e) {
                throw new MojoExecutionException("could not parse effectivate date " + this.effectiveDate + " for reason " + e.getMessage(), (Exception)e);
            }
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        Version v = this.getProjectVersion(this.versionId);
        String safePreviousVersionName = null;
        if (StringUtils.isNotBlank((String)this.previousVersionName)) {
            Version previousVersion = this.getProjectVersion(this.previousVersionName);
            if (previousVersion == null) {
                this.getLog().warn((CharSequence)("can not find the previous version " + this.previousVersionName));
            } else {
                safePreviousVersionName = this.previousVersionName;
            }
            if (this.useLatestClosedVersion) {
                this.getLog().warn((CharSequence)"useLatestClosedVersion flag has no effect when previousVersionName property is filled.");
            }
        } else if (this.useLatestClosedVersion) {
            Version previousVersion = this.service.getLastestClosedVersion(this.projectId);
            if (previousVersion == null) {
                this.getLog().warn((CharSequence)"No latest closed version");
            } else {
                this.getLog().info((CharSequence)("Will use as previous version (the latest closed one): " + previousVersion.getName()));
                safePreviousVersionName = previousVersion.getName();
            }
        }
        if (v == null) {
            v = new Version();
            v.setName(this.versionId);
        }
        if (StringUtils.isNotBlank((String)this.versionDescription)) {
            v.setDescription(this.versionDescription.trim());
        }
        if (this.date != null) {
            v.setEffectiveDate(this.date);
        }
        this.releaseVersion = v;
        if (!this.dryRun) {
            this.getLog().info((CharSequence)("next version " + this.releaseVersion.getName() + (safePreviousVersionName != null ? " from previous version " + safePreviousVersionName : "")));
            this.service.nextVersion(this.projectId, safePreviousVersionName, this.releaseVersion);
        }
    }
}

