/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.announcement.AnnouncementGeneratorConfiguration;
import org.nuiton.plugin.PluginHelper;

public class AnnouncementGenerator {
    private static final String URL_TOKEN = "%URL%";
    private static final String ATTACHMENT_TOKEN = "%FILE%";
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(.+)?--(.+)?");
    private final AnnouncementGeneratorConfiguration configuration;

    public AnnouncementGenerator(AnnouncementGeneratorConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAttachmentLinkTemplate() {
        return this.configuration.getAttachmentLinkTemplate();
    }

    public Log getLog() {
        return this.configuration.getLog();
    }

    public String getUrl() {
        return this.configuration.getUrl().toString();
    }

    public Map<Attachment, String> getAttachmentsUrls(Attachment[] attachments) {
        boolean hasAttachmentLinks = this.canGenerateAttachmentLinks();
        LinkedHashMap<Attachment, String> urls = null;
        if (hasAttachmentLinks) {
            urls = new LinkedHashMap<Attachment, String>();
            for (Attachment a : attachments) {
                String u = this.parseAttachmentLink(a.getId() + "");
                urls.put(a, u);
            }
        } else {
            this.getLog().warn((CharSequence)"can not render attachments urls");
        }
        return urls;
    }

    public Map<File, String> getArtifactsUrls(String url, String versionId, boolean verbose, File[] files) {
        LinkedHashMap<File, String> urls = new LinkedHashMap<File, String>();
        ArrayList<String> groupIds = new ArrayList<String>();
        ArrayList<ArtifactInfo> list = new ArrayList<ArtifactInfo>();
        for (File f : files) {
            ArtifactInfo artifactInfo = new ArtifactInfo(url, versionId, f);
            list.add(artifactInfo);
            if (groupIds.contains(artifactInfo.groupId)) continue;
            if (verbose) {
                this.getLog().info((CharSequence)("detected groupId " + artifactInfo.groupId));
            }
            groupIds.add(artifactInfo.groupId);
        }
        Collections.sort(list, new ArtifactComparator(groupIds));
        for (ArtifactInfo a : list) {
            if (verbose) {
                this.getLog().info((CharSequence)("artifact file " + a.src.getName() + " --> " + a.url));
            }
            urls.put(a.src, a.url);
        }
        return urls;
    }

    public Context createVelocityContext(List<?> releases) throws MojoExecutionException {
        VelocityContext context = new VelocityContext();
        context.put("releases", releases);
        context.put("groupId", (Object)this.configuration.getGroupId());
        context.put("artifactId", (Object)this.configuration.getArtifactId());
        context.put("version", (Object)this.configuration.getVersionId());
        context.put("packaging", (Object)this.configuration.getPackaging());
        context.put("url", (Object)this.configuration.getUrl());
        context.put("projectUrl", (Object)this.configuration.getProjectUrl());
        Release release = this.getLatestRelease(releases, this.configuration.getVersionId());
        context.put("release", (Object)release);
        context.put("introduction", (Object)this.configuration.getIntroduction());
        context.put("developmentTeam", (Object)this.configuration.getDevelopmentTeam());
        context.put("finalName", (Object)this.configuration.getFinalName());
        context.put("urlDownload", (Object)this.configuration.getUrlDownload());
        context.put("mavenRepoUrl", (Object)this.configuration.getDeploymentUrl());
        context.put("project", (Object)this.configuration.getProject());
        Map<File, String> artifactUrls = this.configuration.getArtifactUrls();
        if (artifactUrls == null || artifactUrls.isEmpty()) {
            context.put("withArtifacts", (Object)false);
        } else {
            context.put("withArtifacts", (Object)true);
            context.put("artifactUrls", artifactUrls);
        }
        Map<Attachment, String> attachmentUrls = this.configuration.getAttachmentUrls();
        if (attachmentUrls == null || attachmentUrls.isEmpty()) {
            context.put("withAttachments", (Object)false);
        } else {
            context.put("withAttachments", (Object)true);
            context.put("attachmentUrls", attachmentUrls);
        }
        Map<String, Object> announceParameters = this.configuration.getAnnounceParameters();
        if (announceParameters == null) {
            context.put("announceParameters", Collections.emptyMap());
        } else {
            context.put("announceParameters", announceParameters);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerate(VelocityEngine engine, Context context, File out, String templatePath, String templateEncoding) throws MojoExecutionException {
        try {
            PluginHelper.createDirectoryIfNecessary((File)out.getParentFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), templateEncoding);
            try {
                Template velocityTemplate = engine.getTemplate(templatePath, templateEncoding);
                velocityTemplate.merge(context, (Writer)writer);
                ((Writer)writer).flush();
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    public boolean canGenerateAttachmentLinks() {
        String attachmentLinkTemplate = this.getAttachmentLinkTemplate();
        String url = this.getUrl();
        return !StringUtils.isBlank((String)attachmentLinkTemplate) && attachmentLinkTemplate.indexOf(ATTACHMENT_TOKEN) > 0 && (!attachmentLinkTemplate.contains(URL_TOKEN) || !StringUtils.isBlank((String)url));
    }

    protected String parseAttachmentLink(String id) {
        String issueLink = this.getAttachmentLinkTemplate();
        String parseLink = issueLink.replaceFirst(ATTACHMENT_TOKEN, id);
        if (parseLink.contains(URL_TOKEN)) {
            parseLink = parseLink.replaceFirst(URL_TOKEN, this.getUrl());
        }
        return parseLink;
    }

    public Release getLatestRelease(List<?> releases, String releaseVersion) throws MojoExecutionException {
        boolean isFound;
        Release release;
        String pomVersion = releaseVersion;
        this.getLog().debug((CharSequence)("Found " + releases.size() + " releases."));
        for (Object release1 : releases) {
            release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(pomVersion)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        release = this.getRelease(releases, pomVersion);
        boolean bl = isFound = release != null;
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases.");
        }
        return release;
    }

    protected Release getRelease(List<?> releases, String version) {
        for (Object release1 : releases) {
            Release release = (Release)release1;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("The release: " + release.getVersion() + " has " + release.getActions().size() + " actions."));
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found the correct release: " + release.getVersion()));
                this.logRelease(release);
            }
            return release;
        }
        return null;
    }

    private void logRelease(Release release) {
        for (Object o : release.getActions()) {
            Action action = (Action)o;
            this.getLog().debug((CharSequence)("o " + action.getType()));
            this.getLog().debug((CharSequence)("issue : " + action.getIssue()));
            this.getLog().debug((CharSequence)("action : " + action.getAction()));
            this.getLog().debug((CharSequence)("dueTo : " + action.getDueTo()));
            this.getLog().debug((CharSequence)("dev : " + action.getDev()));
        }
    }

    protected class ArtifactComparator
    implements Comparator<ArtifactInfo> {
        final List<String> groupIds;

        public ArtifactComparator(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @Override
        public int compare(ArtifactInfo o1, ArtifactInfo o2) {
            int result = this.groupIds.indexOf(o1.groupId) - this.groupIds.indexOf(o2.groupId);
            if (result != 0) {
                return result;
            }
            result = o1.extension.compareTo(o2.extension);
            if (result != 0) {
                if ("pom".equals(o1.extension)) {
                    return -1;
                }
                if ("pom".equals(o2.extension)) {
                    return 1;
                }
                return result;
            }
            result = o1.filename.compareTo(o2.filename);
            return result;
        }
    }

    private class ArtifactInfo {
        private File src;
        private String groupId;
        private String artifactId;
        private String url;
        private String extension;
        private String filename;

        public ArtifactInfo(String url, String versionId, File srcfile) {
            String artifactInfo = srcfile.getParentFile().getName();
            Matcher matcher = ARTIFACT_PATTERN.matcher(artifactInfo);
            if (!matcher.matches()) {
                AnnouncementGenerator.this.getLog().error((CharSequence)("no matching for file " + artifactInfo + " (" + srcfile + ")"));
            }
            this.artifactId = matcher.group(2);
            this.groupId = matcher.group(1).replaceAll("\\.", "/") + "/" + this.artifactId;
            String filename = srcfile.getName();
            if ("pom.xml".equals(filename)) {
                filename = this.artifactId + "-" + versionId + ".pom";
                this.src = new File(filename);
            } else {
                this.src = srcfile;
            }
            this.url = url + this.groupId + "/" + versionId + "/" + filename;
            this.extension = FileUtils.getExtension((String)this.src.getName());
            this.filename = this.src.getName().substring(0, this.extension.length() - 1);
        }
    }
}

