/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProject;
import org.nuiton.jredmine.plugin.RedmineVersionAware;

public abstract class AbstractRedmineReport
extends AbstractRedmineMojoWithProject
implements MavenReport,
RedmineVersionAware {
    @Parameter(property="redmine.versionId", defaultValue="${project.version}")
    protected String versionId;
    @Parameter(property="redmine.issueLinkTemplate", defaultValue="%URL%/issues/%ISSUE%")
    protected String issueLinkTemplate = "%URL%/issues/%ISSUE%";
    @Parameter(property="redmine.versionLinkTemplate", defaultValue="%URL%/versions/%VERSION%")
    protected String versionLinkTemplate = "%URL%/versions/%VERSION%";
    @Parameter(property="localRepository", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.reporting.outputDirectory}")
    protected File outputDirectory;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected I18N i18n;
    @Component
    protected Renderer siteRenderer;
    private Sink sink;
    private File reportOutputDirectory;

    protected abstract void executeReport(Locale var1) throws MavenReportException;

    protected abstract boolean skipReport();

    protected AbstractRedmineReport() {
        super(false);
    }

    @Override
    public final String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction() throws Exception {
        try {
            DecorationModel model = new DecorationModel();
            model.setBody(new Body());
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("outputEncoding", this.encoding);
            Locale currentLocale = Locale.getDefault();
            SiteRenderingContext siteContext = this.siteRenderer.createContextForSkin(this.getSkinArtifactFile(), attributes, model, this.getName(currentLocale), currentLocale);
            this.createDirectoryIfNecessary(this.outputDirectory);
            String filename = this.getOutputName() + ".html";
            File file = new File(this.outputDirectory, filename);
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            this.generate((org.codehaus.doxia.sink.Sink)sink, currentLocale);
            try (FileWriter writer = new FileWriter(file);){
                this.siteRenderer.generateDocument((Writer)writer, sink, siteContext);
            }
            this.siteRenderer.copyResources(siteContext, new File(this.project.getBasedir(), "src/site/resources"), this.outputDirectory);
        }
        catch (RendererException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)e);
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
        finally {
            this.closeService();
        }
    }

    public boolean canGenerateReport() {
        boolean init;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"check can use report");
        }
        if (this.skipReport()) {
            this.getLog().info((CharSequence)("User ask to skip report \"" + this.getName(Locale.ENGLISH) + "\"."));
            return false;
        }
        if (this.session.getSettings().isOffline()) {
            this.getLog().info((CharSequence)("Skipped \"" + this.getName(Locale.ENGLISH) + "\" report in offline mode."));
            return false;
        }
        try {
            this.init();
            init = true;
        }
        catch (Exception ex) {
            if (this.isVerbose()) {
                this.getLog().error((CharSequence)("could not init report goal for reason " + ex.getMessage()), (Throwable)ex);
            } else {
                this.getLog().error((CharSequence)("could not init report goal for reason " + ex.getMessage()));
            }
            init = false;
        }
        if (!init) {
            this.getLog().info((CharSequence)("Skipped \"" + this.getName(Locale.ENGLISH) + "\" report, goal could be initialized."));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("check can use report : " + init));
        }
        return init;
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        if (sink == null) {
            throw new MavenReportException("You must specify a sink.");
        }
        this.sink = sink;
        this.executeReport(locale);
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.outputDirectory.getAbsolutePath());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    protected Sink getSink() {
        return this.sink;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("redmine-report", locale, this.getClass().getClassLoader());
    }

    protected File getSkinArtifactFile() throws MojoExecutionException {
        Skin skin = Skin.getDefaultSkin();
        String version = skin.getVersion();
        if (version == null) {
            version = "RELEASE";
        }
        Artifact artifact = this.repositorySystem.createArtifact(skin.getGroupId(), skin.getArtifactId(), version, "jar");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setLocalRepository(this.localRepository);
        this.repositorySystem.resolve(request);
        return artifact.getFile();
    }
}

