/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.jredmine.client.RedmineClientAuthConfiguration;
import org.nuiton.jredmine.client.RedmineClientConfiguration;
import org.nuiton.jredmine.client.RedmineRequest;
import org.nuiton.jredmine.client.RedmineRequestHelper;
import org.nuiton.jredmine.model.io.xpp3.RedmineXpp3Helper;

public class RedmineClient
implements Closeable {
    private static final Log log = LogFactory.getLog(RedmineClient.class);
    protected final RedmineXpp3Helper xpp3Helper;
    protected final RedmineClientConfiguration configuration;
    protected final HttpClient client;
    protected final URI serverURI;
    protected final HttpClientConnectionManager connectionManager;
    protected boolean showRequest;
    protected boolean open;

    public RedmineClient(RedmineClientConfiguration configuration) {
        this.configuration = configuration;
        this.xpp3Helper = new RedmineXpp3Helper();
        this.showRequest = configuration.isVerbose();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        RedmineClientAuthConfiguration authConfiguration = configuration.getAuthConfiguration();
        if (authConfiguration.isUseApiKey()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will use api key for authentication");
            }
            headers.add(new BasicHeader("X-Redmine-API-Key", authConfiguration.getApiKey()));
        }
        this.connectionManager = new BasicHttpClientConnectionManager();
        this.client = HttpClientBuilder.create().setDefaultHeaders(headers).setConnectionManager(this.connectionManager).disableRedirectHandling().disableAuthCaching().disableCookieManagement().disableConnectionState().build();
        try {
            this.serverURI = configuration.getUrl().toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not get uri from " + configuration.getUrl());
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            RedmineRequest<String> pingRequest = RedmineRequestHelper.action("ping", String.class);
            this.open = true;
            try {
                String content = this.executeRequest(pingRequest);
                boolean ok = "ping".equals(content);
                if (!ok) {
                    throw new IOException("can not connect to " + this.configuration.getUrl());
                }
            }
            catch (RuntimeException e) {
                this.open = false;
                throw e;
            }
            catch (IOException e) {
                this.open = false;
                throw e;
            }
            this.open = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeRequest(RedmineRequest<T> request) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException("the client is not opened");
        }
        try {
            Object result;
            HttpRequestBase gm = this.prepareRequest(request);
            RedmineSimpleResponseHandler<T> responseHandler = new RedmineSimpleResponseHandler<T>(false, request.getType(), this.xpp3Helper, gm.getURI().toString());
            Object object = result = this.client.execute((HttpUriRequest)gm, responseHandler);
            return (T)object;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] executeRequests(RedmineRequest<T> request) throws IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException("the client is not opened");
        }
        try {
            Object[] result;
            HttpRequestBase gm = this.prepareRequest(request);
            RedmineArrayResponseHandler<T> responseHandler = new RedmineArrayResponseHandler<T>(false, request.getType(), this.xpp3Helper, gm.getURI().toString());
            Object[] objectArray = result = (Object[])this.client.execute((HttpUriRequest)gm, responseHandler);
            return objectArray;
        }
        finally {
            this.releaseConnection();
        }
    }

    public RedmineClientConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.open) {
            try {
                this.connectionManager.shutdown();
            }
            finally {
                this.open = false;
            }
        }
    }

    protected <T> HttpRequestBase prepareRequest(RedmineRequest<T> request) throws IOException {
        HttpGet gm;
        if (this.showRequest) {
            log.info((Object)("prepareRequest " + this.getRequestUrl(request)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("prepareRequest with parameters: " + request.getParams()));
        }
        switch (request.getMethod()) {
            case GET: {
                gm = this.prepareGetRequest(request);
                break;
            }
            case POST: {
                gm = this.preparePostRequest(request);
                break;
            }
            case PUT: {
                gm = this.preparePutRequest(request);
                break;
            }
            case DELETE: {
                gm = this.prepareDeleteRequest(request);
                break;
            }
            default: {
                throw new IllegalStateException("Can not deal with method " + (Object)((Object)request.getMethod()));
            }
        }
        return gm;
    }

    protected <T> String getRequestUrl(RedmineRequest<T> request) {
        String result = request.toPath(this.serverURI.toString());
        return result;
    }

    protected <T> HttpGet prepareGetRequest(RedmineRequest<T> request) throws IOException {
        String uri = this.getRequestUrl(request);
        Map<String, String> parameters = request.getParams();
        Map<String, File> attachments = request.getAttachments();
        Preconditions.checkState((boolean)MapUtils.isEmpty(attachments), (Object)"Can not do a GET request with multi-parts, use a POST or UPDATE request");
        HttpGet gm = new HttpGet(uri);
        this.addParams((HttpRequestBase)gm, parameters);
        return gm;
    }

    protected <T> HttpDelete prepareDeleteRequest(RedmineRequest<T> request) throws IOException {
        String uri = this.getRequestUrl(request);
        Map<String, String> parameters = request.getParams();
        Map<String, File> attachments = request.getAttachments();
        Preconditions.checkState((boolean)MapUtils.isEmpty(attachments), (Object)"Can not do a GET request with multi-parts, use a POST or UPDATE request");
        HttpDelete gm = new HttpDelete(uri);
        this.addParams((HttpRequestBase)gm, parameters);
        return gm;
    }

    protected <T> HttpPost preparePostRequest(RedmineRequest<T> request) throws IOException {
        String uri = this.getRequestUrl(request);
        Map<String, String> parameters = request.getParams();
        Map<String, File> attachments = request.getAttachments();
        HttpPost gm = new HttpPost(uri);
        if (MapUtils.isEmpty(attachments)) {
            this.addParamsAsEntity((HttpEntityEnclosingRequest)gm, parameters);
        } else {
            this.prepareMultiPart((HttpEntityEnclosingRequestBase)gm, attachments, parameters);
        }
        return gm;
    }

    protected <T> HttpPut preparePutRequest(RedmineRequest<T> request) throws IOException {
        String uri = this.getRequestUrl(request);
        Map<String, String> parameters = request.getParams();
        Map<String, File> attachments = request.getAttachments();
        HttpPut gm = new HttpPut(uri);
        if (MapUtils.isEmpty(attachments)) {
            this.addParamsAsEntity((HttpEntityEnclosingRequest)gm, parameters);
        } else {
            this.prepareMultiPart((HttpEntityEnclosingRequestBase)gm, attachments, parameters);
        }
        return gm;
    }

    protected void addParams(HttpRequestBase gm, Map<String, String> parameters) throws IOException {
        if (MapUtils.isNotEmpty(parameters)) {
            URIBuilder uriBuilder = new URIBuilder(gm.getURI());
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skip null parameter " + key));
                    continue;
                }
                uriBuilder.addParameter(key, value);
            }
            try {
                URI uri = uriBuilder.build();
                gm.setURI(uri);
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not build uri", e);
            }
        }
    }

    protected void addParamsAsEntity(HttpEntityEnclosingRequest gm, Map<String, String> parameters) throws IOException {
        if (MapUtils.isNotEmpty(parameters)) {
            ArrayList params = Lists.newArrayList();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skip null parameter " + key));
                    continue;
                }
                params.add(new BasicNameValuePair(key, value));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)params, this.configuration.getEncoding());
            gm.setEntity((HttpEntity)entity);
        }
    }

    protected void prepareMultiPart(HttpEntityEnclosingRequestBase gm, Map<String, File> attachments, Map<String, String> parameters) throws IOException {
        String key;
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        if (MapUtils.isNotEmpty(parameters)) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                key = entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skip null parameter " + key));
                    continue;
                }
                multipartEntityBuilder.addTextBody(key, value);
            }
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            key = entry.getKey();
            File file = (File)entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("add attachment " + key + "=" + file));
            }
            multipartEntityBuilder.addBinaryBody(key, file);
        }
        if (attachments.isEmpty()) {
            log.warn((Object)"no attachment in a multi-part request!");
        }
        HttpEntity entity = multipartEntityBuilder.build();
        if (log.isDebugEnabled()) {
            entity.writeTo((OutputStream)System.out);
        }
        gm.setEntity(entity);
        gm.addHeader("content-type", entity.getContentType().getValue());
        if (this.showRequest) {
            log.info((Object)("content-type : " + entity.getContentType() + ", content-length : " + entity.getContentLength()));
        }
    }

    protected void releaseConnection() {
        this.connectionManager.closeExpiredConnections();
    }

    protected static class RedmineArrayResponseHandler<T>
    extends AbstractRedmineResponseHandler<T>
    implements ResponseHandler<T[]> {
        RedmineArrayResponseHandler(boolean strict, Class<T> type, RedmineXpp3Helper xpp3Helper, String uri) {
            super(strict, type, xpp3Helper, uri);
        }

        public T[] handleResponse(HttpResponse response) throws IOException {
            this.checkResponse(response);
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            try {
                O[] result = this.xpp3Helper.readObjects(this.type, inputStream, this.strict);
                inputStream.close();
                O[] OArray = result;
                return OArray;
            }
            catch (XmlPullParserException e) {
                throw new IOException("Could not parse response fro type " + this.type, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    protected static class RedmineSimpleResponseHandler<T>
    extends AbstractRedmineResponseHandler<T>
    implements ResponseHandler<T> {
        RedmineSimpleResponseHandler(boolean strict, Class<T> type, RedmineXpp3Helper xpp3Helper, String uri) {
            super(strict, type, xpp3Helper, uri);
        }

        public T handleResponse(HttpResponse response) throws IOException {
            String result;
            this.checkResponse(response);
            HttpEntity entity = response.getEntity();
            if (Void.class == this.type || Void.TYPE == this.type) {
                EntityUtils.consume((HttpEntity)entity);
                result = null;
            } else if (String.class == this.type) {
                result = EntityUtils.toString((HttpEntity)entity);
            } else {
                InputStream inputStream = entity.getContent();
                try {
                    result = this.xpp3Helper.readObject(this.type, inputStream, this.strict);
                    inputStream.close();
                }
                catch (XmlPullParserException e) {
                    throw new IOException("Could not parse response fro type " + this.type, e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            return (T)result;
        }
    }

    protected static abstract class AbstractRedmineResponseHandler<T> {
        final boolean strict;
        final Class<T> type;
        protected final RedmineXpp3Helper xpp3Helper;
        final String uri;

        AbstractRedmineResponseHandler(boolean strict, Class<T> type, RedmineXpp3Helper xpp3Helper, String uri) {
            this.strict = strict;
            this.type = type;
            this.xpp3Helper = xpp3Helper;
            this.uri = uri;
        }

        protected void checkResponse(HttpResponse response) throws IOException {
            StatusLine sl = response.getStatusLine();
            int statusCode = sl.getStatusCode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("status code " + statusCode + " for " + this.uri));
            }
            HttpEntity entity = response.getEntity();
            if (statusCode == 404) {
                String responseAsString = EntityUtils.toString((HttpEntity)entity);
                throw new IOException("could not retreave some datas : " + responseAsString);
            }
            if (statusCode != 200) {
                String responseAsString = EntityUtils.toString((HttpEntity)entity);
                log.error((Object)("Error = " + responseAsString));
                throw new IOException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + this.uri);
            }
        }
    }
}

