/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.nuiton.jredmine.client.RedmineClient;
import org.nuiton.jredmine.client.RedmineRequest;
import org.nuiton.jredmine.service.RedmineConfigurationUtil;
import org.nuiton.jredmine.service.RedmineServiceConfiguration;
import org.nuiton.jredmine.service.RedmineServiceException;
import org.nuiton.jredmine.service.RedmineServiceLoginException;

public abstract class AbstractRedmineService {
    private RedmineClient client;

    public boolean isInit() {
        return this.client != null && this.client.isOpen();
    }

    public void init(RedmineServiceConfiguration configuration) throws RedmineServiceException {
        Preconditions.checkNotNull((Object)configuration, (Object)"the client configuration was not be null!");
        Preconditions.checkState((!this.isInit() ? 1 : 0) != 0, (Object)("the client " + this + " was already init!"));
        this.client = new RedmineClient(configuration);
        try {
            this.client.open();
        }
        catch (Exception e) {
            throw new RedmineServiceException("could not init service for reason " + e.getMessage(), e);
        }
    }

    public void destroy() throws RedmineServiceException {
        block7: {
            if (this.isInit()) {
                try {
                    if (!this.client.isOpen()) break block7;
                    try {
                        this.client.close();
                    }
                    catch (IOException e) {
                        throw new RedmineServiceException("has problem while closing Rest client " + e.getMessage(), e);
                    }
                }
                finally {
                    if (this.client != null) {
                        this.client = null;
                    }
                }
            }
        }
    }

    public RedmineClient getClient() {
        return this.client;
    }

    protected <T> T executeRequestAndReturnData(RedmineRequest<T> request) throws RedmineServiceException {
        this.checkInit();
        try {
            T result = this.client.executeRequest(request);
            return result;
        }
        catch (Exception ex) {
            throw new RedmineServiceException("could not obtain datas of type " + request.getType() + " for reason " + ex.getMessage(), ex);
        }
    }

    protected <T> T[] executeRequestAndReturnDatas(RedmineRequest<T> request) throws RedmineServiceException {
        this.checkInit();
        try {
            T[] result = this.client.executeRequests(request);
            return result;
        }
        catch (Exception ex) {
            throw new RedmineServiceException("could not obtain datas of type " + request.getType() + " for reason " + ex.getMessage(), ex);
        }
    }

    protected void checkInit() throws IllegalStateException {
        if (!this.isInit()) {
            throw new IllegalStateException("the client " + this + " is not init!");
        }
    }

    protected void checkSessionNotNull() {
        if (this.client == null) {
            throw new NullPointerException("session can not be null");
        }
    }

    protected void checkSessionConfigurationNotNull() {
        if (this.client.getConfiguration() == null) {
            throw new NullPointerException("session configuration can not be null");
        }
    }

    protected void checkLoggued() throws IllegalStateException, RedmineServiceLoginException, NullPointerException {
        boolean anonymous;
        this.checkInit();
        this.checkSessionNotNull();
        this.checkSessionConfigurationNotNull();
        boolean bl = anonymous = !RedmineConfigurationUtil.isLoggued(this.client.getConfiguration());
        if (anonymous) {
            throw new RedmineServiceLoginException("can not access this service in anonymous mode");
        }
    }
}

