/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.model.io.xpp3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.jredmine.model.io.xpp3.api.Xpp3Helper;
import org.nuiton.jredmine.model.io.xpp3.api.Xpp3Reader;

public class RedmineXpp3Helper {
    private static final Log log = LogFactory.getLog(RedmineXpp3Helper.class);

    public <O> O readObject(Class<O> klass, String txt, boolean strict) throws IOException, XmlPullParserException {
        O result = this.readObject(klass, new ByteArrayInputStream(txt.getBytes()), strict);
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, String txt, boolean strict) throws IOException, XmlPullParserException {
        O[] results = this.readObjects(klass, new ByteArrayInputStream(txt.getBytes()), strict);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O readObject(Class<O> klass, File file, boolean strict) throws IOException, XmlPullParserException {
        try (FileInputStream stream = new FileInputStream(file);){
            O result;
            O o = result = this.readObject(klass, stream, strict);
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] readObjects(Class<O> klass, File file, boolean strict) throws IOException, XmlPullParserException {
        try (FileInputStream stream = new FileInputStream(file);){
            O[] results;
            O[] OArray = results = this.readObjects(klass, stream, strict);
            return OArray;
        }
    }

    public <O> O readObject(Class<O> klass, InputStream stream, boolean strict) throws IOException, XmlPullParserException {
        O result = this.readObject(klass, (Reader)ReaderFactory.newXmlReader((InputStream)stream), strict);
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, InputStream stream, boolean strict) throws IOException, XmlPullParserException {
        O[] results = this.readObjects(klass, (Reader)ReaderFactory.newXmlReader((InputStream)stream), strict);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] readObjects(Class<O> klass, Reader reader, boolean strict) throws IOException, XmlPullParserException {
        if (klass == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader parameter can not be null");
        }
        Xpp3Reader<O> modelReader = Xpp3Helper.getReader(klass);
        if (modelReader == null) {
            throw new IllegalArgumentException("could not find xpp3Reader for type " + klass);
        }
        O[] result = null;
        try {
            StringWriter sWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)sWriter);
            String rawInput = sWriter.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("content to read : \n" + rawInput));
            }
            StringReader sReader = new StringReader(rawInput);
            result = modelReader.readArray(sReader, strict);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O readObject(Class<O> klass, Reader reader, boolean strict) throws IOException, XmlPullParserException {
        if (klass == null) {
            throw new NullPointerException("klass parameter can not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader parameter can not be null");
        }
        Xpp3Reader<O> modelReader = Xpp3Helper.getReader(klass);
        if (modelReader == null) {
            throw new IllegalArgumentException("could not find xpp3Reader for type " + klass);
        }
        O result = null;
        try {
            StringWriter sWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)sWriter);
            String rawInput = sWriter.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("content to read : \n" + rawInput));
            }
            StringReader sReader = new StringReader(rawInput);
            result = modelReader.read(sReader, strict);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return result;
    }
}

