/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.table.filter;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.jaxx.runtime.swing.table.filter.TableFilter;

class TableFilterState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Set<Object>> data = new HashMap<Integer, Set<Object>>();

    TableFilterState() {
    }

    public void clear(int column) {
        this.data.remove(column);
    }

    public void clear() {
        this.data.clear();
    }

    private Set<Object> prepareValueSet(int column) {
        Set<Object> vals = this.data.get(column);
        if (vals == null) {
            vals = new HashSet<Object>();
            this.data.put(column, vals);
        }
        return vals;
    }

    public void addValue(int column, Object value) {
        this.prepareValueSet(column).add(value);
    }

    public void addValues(int column, Collection<Object> values) {
        this.prepareValueSet(column).addAll(values);
    }

    public void setValues(int column, Collection<Object> values) {
        this.data.remove(column);
        if (CollectionUtils.isNotEmpty(values)) {
            this.prepareValueSet(column).addAll(values);
        }
    }

    public Collection<Object> getValues(int column) {
        Set<Object> vals = this.data.get(column);
        return vals == null ? Collections.emptySet() : vals;
    }

    public boolean include(TableFilter.Row entry) {
        for (int col = 0; col < entry.getValueCount(); ++col) {
            Collection<Object> values = this.getValues(col);
            if (CollectionUtils.isEmpty(values) || values.contains(entry.getValue(col))) continue;
            return false;
        }
        return true;
    }
}

