package jaxx.runtime.swing.editor.bean;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.bean.BeanTypeAware;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.model.JaxxDefaultComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.JXPathDecorator;
import static org.nuiton.i18n.I18n.t;

public class BeanComboBox<O> extends Table implements BeanTypeAware<O>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";
    public static final String PROPERTY_AUTO_FOCUS = "autoFocus";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_FORCE = "force";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_MAXIMUM_ROW_COUNT = "maximumRowCount";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SORTABLE = "sortable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CHANGE_DECORATOR_ENABLED = "changeDecorator.enabled";
    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_MAXIMUM_ROW_COUNT = "combobox.maximumRowCount";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";
    public static final String BINDING_TOOLBAR_RIGHT_VISIBLE = "toolbarRight.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XzU8bRxQfHGwwGAilQYkKkoEoAlUY0lNU0oQCIRCZBhk3iopUdewd7InWO9vdWWxkUfVP6J/Q3nup1FtPVQ8999BL1X+hanPotep7sx+zu2xkEOGwgvf5e2/eF9//RfKuQxZe0V6v4niW5B1Wefbxy5fPG69YU+4wt+lwWwqH+D9DOZI7JuNGRHclWTquovpaoL62LTq2sJgV096okjFXnpnMbTMmJZlPajRdd+0oYm/0bM8JrUagsqx++/rv3DfG19/lCOnZgG4JQikP0tKRDFdJjhuSvAOeTumaSa0WwHC41QK8E0jbNqnrfkI77EvyFRmpkoJNHTAmyeLlQ1Y2lH7PlmTkbp02TLYuyfsJoG4X3FaYwUG10mDUqmzBB+w2xJbo2bayUJBkFHn1M5tJMoUIK4i6onxooRL1pEBMJpMgOK0Ft4QwwYAWHXfYKXNcdiQciaRpzSq6bdGtMZelGRPI2GFN4VBAm2KOYgwYYprugocMehGx7oqm56YVbEfYzJFnktzUAfjvo6WGMR8JCb9yY8lwmQkEZuxL1kHakubluWWwXiJD+5ZkLebEPBhUUkkmlYgnuVmpcjdmf6pDe7zjdWqiuy3gNZG8rNkjygWDPlnMeHBstS1PSmE9dYRnx5MP6VI0JKzH7LWpZZiQF/LBFQpoz1fSZmbCrNShIurcrkMakFXWIrOWkEcDpSZtYXt2nUuTZXDH+P0H1qHDTngvxcmfCKeZLoa8MgauMdm9MEeHSDxglpf2ikVbpQ1mQg8nNBQRRTcjjQIm9FOwXU5I1qjBhf8C6CGskc1k3e6IroV/7yV5AQoGUwE7IY07YiS1xpRWBPFJklu6q/XWkXaQ5I9LeIoGdarsBObQuwmH+EpbVLkrxjscWtgPEd49oeBTUbCmA25izTQEtMWthHBYS0nzpQBPjbfa6vXrSf5UEwq2xaJxIcmdFOZWy2QayLENQ/y9RGnDeqjo9aDn99AxyTueib11+/jiRqkBy98lt1O7BA0q7n+zM7//9OePu+ECuQm+b2WKxvYfDPZgNHF0PeVvD5wMawfU3jiG3lVdo5bjXAawo4AN4MDftB4se9Rtg4n8yB8//zL7xW83SG6XjJmCGrsU5fdJUbbhNdvCNHr2402FqNQdReCIDQrSc1msVWF4ScdjPUjBXEYKIhyN4q//zhz9sBmmYQhg3XmjuE5F/jNS4JbJLaY2abAkMzfnuO0yzxB6GWatR6LHZTgKmfryC8HmcA0Fw+kFNT1cc33u1vQ2W145f3NC0GhHRYq/CRIfuINcQ54LDeEYOIPv9y3WLavpZ2wp2rJcXsTxG3ZRRXV7RaLI4srKeZZvf+xdIuQxqAMurP0mtnIR3awibAxLRTelBj+SYJnBfMlylhqdg7zmYYI09IaKJyqFpxThWUVeAKmkISE1f+o/1kj/hJouO8cBGzwjDPH+QvoJsyIIRvnbQz6pkRsw6SPskxq7Tw/RF/pYRknwF8svC3u0TgahvwEF7lfZIeWW8pBXKYPcnXKXwyUF7w0+j8IrTRV88QTmhbqzQvksFPElcok0JpMVVvaqWizoEq+3uMvAQdR084mG8I1VlDb0BR7FzEJ1CHEeAnoSHJDLK+V798rwt89U4ZWUr1RGMiOMbb1BEaaPRNiS/RaLbh8kKefRaQtJSOAEXr4jDLxDltRAeAazc4edUM+U4dY8QP7D54+CV9IpUyGHIQYRxy3r5Ez0k8lIX56SbPTLAPwgSQarCx+VLc80y4+z2R+WH5SzqzV8tLdSrTNBtUa3wBUqNnFmXLVkJ6KS9afl4Iqdy6pYNQhSBbt4MaZrVG36WLrEKhrmflc+xH9Tyg1Yn3BWPbpgfAi/OwPtIfkf/LzOtvD02haeXdvCi2tb+Bws/A/Aoe90+hAAAA==";
    private static final Log log = LogFactory.getLog(BeanComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoComplete;
    protected Boolean autoFocus;
    protected Object bean;
    protected Class<O> beanType;
    protected JToggleButton changeDecorator;
    protected JComboBox combobox;
    protected List<O> data;
    protected Boolean editable;
    protected Boolean force;
    protected BeanComboBoxHandler<O> handler;
    protected String i18nPrefix;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected Integer maximumRowCount;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected String popupTitleText;
    protected String property;
    protected JButton resetButton;
    protected Boolean reverseSort;
    protected Object selectedItem;
    protected String selectedToolTipText;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected Boolean sortable;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private BeanComboBox<O> $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EMPTY = "empty";
    
    
    public void init(JXPathDecorator<O> decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    
    public boolean isEmpty() { return handler.isEmpty(); }
    
    public void addItem(O item) { handler.addItem(item); }
    
    public void addItems(Iterable<O> items) { handler.addItems(items); }
    
    public void removeItem(O item) { handler.removeItem(item); }
    
    public void removeItems(Iterable<O> items) { handler.removeItems(items); }
    
    public JaxxDefaultComboBoxModel<O> getComboBoxModel() { return (JaxxDefaultComboBoxModel<O>) combobox.getModel(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanComboBox() {
        $initialize();
    }

    public BeanComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__changeDecorator(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().togglePopup();
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedItem(null);
    }

    public void doFocusGained__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.focusCombo();
    }

    public void doFocusGained__on__combobox(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doFocusLost__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getChangeDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoComplete() {
        return autoComplete;
    }

    public Boolean getAutoFocus() {
        return autoFocus;
    }

    public Object getBean() {
        return bean;
    }

    public Class<O> getBeanType() {
        return beanType;
    }

    public JToggleButton getChangeDecorator() {
        return changeDecorator;
    }

    public JComboBox getCombobox() {
        return combobox;
    }

    public List<O> getData() {
        return data;
    }

    public Boolean getEditable() {
        return editable;
    }

    public Boolean getForce() {
        return force;
    }

    public BeanComboBoxHandler<O> getHandler() {
        return handler;
    }

    public String getI18nPrefix() {
        return i18nPrefix;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public Integer getMaximumRowCount() {
        return maximumRowCount;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public String getPopupTitleText() {
        return popupTitleText;
    }

    public String getProperty() {
        return property;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public Object getSelectedItem() {
        return selectedItem;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public Boolean getSortable() {
        return sortable;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    public Boolean isAutoComplete() {
        return autoComplete !=null && autoComplete;
    }

    public Boolean isAutoFocus() {
        return autoFocus !=null && autoFocus;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isForce() {
        return force !=null && force;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isSortable() {
        return sortable !=null && sortable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoComplete(Boolean autoComplete) {
        Boolean oldValue = this.autoComplete;
        this.autoComplete = autoComplete;
        firePropertyChange(PROPERTY_AUTO_COMPLETE, oldValue, autoComplete);
    }

    public void setAutoFocus(Boolean autoFocus) {
        Boolean oldValue = this.autoFocus;
        this.autoFocus = autoFocus;
        firePropertyChange(PROPERTY_AUTO_FOCUS, oldValue, autoFocus);
    }

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanType(Class<O> beanType) {
        Class<O> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setForce(Boolean force) {
        Boolean oldValue = this.force;
        this.force = force;
        firePropertyChange(PROPERTY_FORCE, oldValue, force);
    }

    public void setI18nPrefix(String i18nPrefix) {
        String oldValue = this.i18nPrefix;
        this.i18nPrefix = i18nPrefix;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, i18nPrefix);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setMaximumRowCount(Integer maximumRowCount) {
        Integer oldValue = this.maximumRowCount;
        this.maximumRowCount = maximumRowCount;
        firePropertyChange(PROPERTY_MAXIMUM_ROW_COUNT, oldValue, maximumRowCount);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupTitleText(String popupTitleText) {
        String oldValue = this.popupTitleText;
        this.popupTitleText = popupTitleText;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, popupTitleText);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setSelectedItem(Object selectedItem) {
        Object oldValue = this.selectedItem;
        this.selectedItem = selectedItem;
        firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, selectedItem);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setSortable(Boolean sortable) {
        Boolean oldValue = this.sortable;
        this.sortable = sortable;
        firePropertyChange(PROPERTY_SORTABLE, oldValue, sortable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSortDown() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarLeft.add(resetButton);
    }

    protected void addChildrenToToolbarRight() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarRight.add(changeDecorator);
    }

    protected void createAutoComplete() {
        $objectMap.put("autoComplete", autoComplete = false);
    }

    protected void createAutoFocus() {
        $objectMap.put("autoFocus", autoFocus = true);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createChangeDecorator() {
        $objectMap.put("changeDecorator", changeDecorator = new JToggleButton());
        
        changeDecorator.setName("changeDecorator");
        changeDecorator.setFocusable(false);
        changeDecorator.setToolTipText(t("beancombobox.action.sort.tip"));
        changeDecorator.setFocusPainted(false);
        changeDecorator.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__changeDecorator"));
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new JComboBox());
        
        combobox.setName("combobox");
        combobox.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__combobox"));
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createForce() {
        $objectMap.put("force", force = false);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new BeanComboBoxHandler<O>(this));
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "entitycombobox.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createMaximumRowCount() {
        $objectMap.put("maximumRowCount", maximumRowCount = null);
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setToolTipText(t("beancombobox.action.reset.tip"));
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedItem() {
        $objectMap.put("selectedItem", selectedItem = null);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createSortable() {
        $objectMap.put("sortable", sortable = true);
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setBorderPainted(false);
        toolbarRight.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(toolbarLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(toolbarRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        popup.setBorder(new TitledBorder(t("beancombobox.popup.title")));
        popupSortLabel.setIcon(SwingUtil.createActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.createActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.createActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        resetButton.setIcon(SwingUtil.createActionIcon("combobox-reset"));
        combobox.setModel(new JaxxDefaultComboBoxModel<O>());
        changeDecorator.setIcon(SwingUtil.createActionIcon("combobox-sort"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createBeanType();
        createAutoComplete();
        createReverseSort();
        createShowReset();
        createShowDecorator();
        createEditable();
        createSortable();
        createAutoFocus();
        createProperty();
        createBean();
        createSelectedItem();
        createIndex();
        createData();
        createMaximumRowCount();
        createIndexes();
        createSortGroup();
        createHandler();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createForce();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createToolbarLeft();
        createResetButton();
        createCombobox();
        createToolbarRight();
        createChangeDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"editable" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEditable() && isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true ,"selectedItem") {
        
            @Override
            public void processDataBinding() {
                combobox.setSelectedItem(getSelectedItem());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_EDITABLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setEditable(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_FOCUSABLE, true ,"enabled" ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setFocusable(isEnabled() && isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_MAXIMUM_ROW_COUNT, true ,"maximumRowCount") {
        
            @Override
            public void processDataBinding() {
                combobox.setMaximumRowCount( getMaximumRowCount() != null ? getMaximumRowCount() : 8 );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RIGHT_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                toolbarRight.setVisible(isShowDecorator());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CHANGE_DECORATOR_ENABLED, true ,"showDecorator" ,"enabled") {
        
            @Override
            public void processDataBinding() {
                changeDecorator.setEnabled(isShowDecorator() && isEnabled());
            }
        });
    }

}