package org.nuiton.jaxx.swing.extra.tabbedpane;

import javax.swing.JTabbedPane;
import java.awt.Component;
import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * A simple iterator on a {@link JTabbedPane}.
 * <p/>
 * Implements the method {@link #get(int, Component)} to obtain
 * the data required given the component (or index).
 * <p/>
 * You can also inverse the order by usin the method {@link #reverse()}.
 * <p/>
 * Note: After the use of the method {@link #reverse()} the iterator returns
 * to the first element.
 *
 * @param <O> the type of return elements.
 * @since 1.4
 */
public abstract class TabbedPaneIterator<O> implements Iterator<O> {

    final JTabbedPane tabs;

    boolean reverse;

    int index;

    int increment;

    protected abstract O get(int index, Component comp);

    public TabbedPaneIterator(boolean reverse, JTabbedPane tabs) {
        this.tabs = tabs;
        setReverse(reverse);
    }

    public void reset() {
        setReverse(reverse);
    }

    public int size() {
        return tabs.getTabCount();
    }

    public TabbedPaneIterator<O> reverse() {
        setReverse(!reverse);
        return this;
    }

    @Override
    public boolean hasNext() {
        return reverse ? index > 0 : index < tabs.getTabCount();
    }

    public int getIndex() {
        return index;
    }

    @Override
    public O next() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        Component next = tabs.getComponentAt(index);
        O result = get(index, next);
        index += increment;
        return result;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("not implemented for " + this);
    }

    @Override
    public String toString() {
        return super.toString() + "< reverse:" + reverse + ", index:" +
               index + ", size:" + tabs.getTabCount() + " >";
    }

    protected void setReverse(boolean reverse) {
        if (reverse) {
            index = tabs.getTabCount() - 1;
            increment = -1;
        } else {
            index = 0;
            increment = 1;
        }
        this.reverse = reverse;
    }
}
