package org.nuiton.jaxx.swing.extra;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.event.HyperlinkEvent;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class Desktops {

    /** Logger. */
    private static final Log log = LogFactory.getLog(Desktops.class);

    /**
     * Open a link coming from a {@link HyperlinkEvent}.
     * <p/>
     * And try to open the link if an url in a browser.
     *
     * @param he the event to treate
     * @since 1.6.0
     */
    public static void openLink(HyperlinkEvent he) {
        if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {

            if (Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") ||
                        u.getProtocol().equalsIgnoreCase("http") ||
                        u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                } catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Error while opening link", e);
                    }
                } catch (URISyntaxException e) {
                    if (log.isErrorEnabled()) {
                        log.error("Error while opening link", e);
                    }
                }
            }
        }
    }

    public static void openLink(String url) {

        try {
            if (!Desktop.isDesktopSupported()) {
                throw new IllegalStateException(
                        t("swing.error.desktop.not.supported"));
            }


            Desktop desktop = Desktop.getDesktop();

            if (!desktop.isSupported(Desktop.Action.BROWSE)) {

                throw new IllegalStateException(
                        t("swing.error.desktop.browse.not.supported"));
            }

            URI uri = new URI(url);
            desktop.browse(uri);
        } catch (Exception e) {

            if (log.isErrorEnabled()) {
                log.error("Error while opening link", e);
            }
        }
    }

    public static void openLink(URI uri) {

        Desktop desktop = getDesktopForBrowse();

        try {

            desktop.browse(uri);
        } catch (Exception e) {

            throw new RuntimeException(
                    t("application.error.cannot.open.link", uri), e);
        }
    }

    public static Desktop getDesktopForBrowse() {

        if (!Desktop.isDesktopSupported()) {
            throw new RuntimeException(
                    t("application.error.desktop.not.supported"));
        }

        Desktop desktop = Desktop.getDesktop();

        if (!desktop.isSupported(Desktop.Action.BROWSE)) {

            throw new RuntimeException(
                    t("application.error.desktop.browse.not.supported"));
        }

        return desktop;
    }

    /**
     * Copy to clipBoard the content of the given text.
     *
     * @param text text to copy to clipboard
     * @since 2.17
     */
    public static void copyToClipBoard(String text) {

        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info("Put in clipboard :\n" + text);
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }
}
