/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.ServiceLoader;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.util.DialogUI;
import org.nuiton.jaxx.util.DialogUIDef;
import org.nuiton.jaxx.util.DialogUIHandler;
import org.nuiton.jaxx.util.DialogUIModel;
import org.nuiton.jaxx.util.FactoryWindowListener;
import org.nuiton.jaxx.util.UIProvider;
import org.nuiton.util.StringUtil;

public class UIFactory {
    protected static final Log log = LogFactory.getLog(UIFactory.class);
    private final String applicationName;
    private final DialogUIDef<?, ?, ?>[] defs;
    private final EventListenerList listeners;

    public UIFactory(String applicationName, DialogUIDef<?, ?, ?>[] defs, FactoryWindowListener ... listeners) {
        this.applicationName = applicationName;
        this.listeners = new EventListenerList();
        for (FactoryWindowListener listener : listeners) {
            listener.setFactory(this);
            this.addFactoryWindowListener(listener);
        }
        this.defs = defs;
        long t0 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("start at " + new Date()));
        }
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.info((Object)("end in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
            }
        }
    }

    public void addFactoryWindowListener(FactoryWindowListener l) {
        this.listeners.add(FactoryWindowListener.class, l);
        if (log.isDebugEnabled()) {
            log.debug((Object)("after added (" + this.listeners.getListenerCount() + ") : " + l));
        }
    }

    public void removeFactoryWindowListener(FactoryWindowListener l) {
        this.listeners.remove(FactoryWindowListener.class, l);
        for (DialogUIDef<?, ?, ?> def : this.getDefs()) {
            if (def.uiInstance == null) continue;
            ((DialogUI)def.uiInstance).removeWindowListener(l);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" after removed (" + this.listeners.getListenerCount() + ") : " + l));
        }
        if (this.listeners.getListenerCount(FactoryWindowListener.class) == 0) {
            this.close();
        }
    }

    public void close() {
        log.info((Object)(this + " at " + new Date()));
        for (DialogUIDef<?, ?, ?> def : this.defs) {
            Object ui = def.uiInstance;
            if (ui == null) continue;
            ((DialogUIHandler)((DialogUI)ui).getHandler()).dispose();
            def.uiInstance = null;
        }
        if (this.listeners.getListenerCount(FactoryWindowListener.class) > 0) {
            log.warn((Object)"some listeners where not properly removed, force deletion...");
            for (FactoryWindowListener listener : (FactoryWindowListener[])this.listeners.getListeners(FactoryWindowListener.class)) {
                this.removeFactoryWindowListener(listener);
            }
        }
    }

    protected void init() {
        UIProvider[] providers = this.detectProviders();
        for (DialogUIDef<?, ?, ?> def : this.defs) {
            this.initDef(providers, def);
            if (def.getUiImplClass() != null) continue;
            throw new IllegalStateException("could not find implementation for ui def " + def);
        }
    }

    protected void initDef(UIProvider[] providers, DialogUIDef<?, ?, ?> def) {
        for (UIProvider provider : providers) {
            Class<?> uiImplClass = provider.findUIImplementation(def);
            if (uiImplClass == null) continue;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("init done for " + def));
            break;
        }
    }

    protected UIProvider[] detectProviders() {
        long t0 = System.nanoTime();
        ArrayList<UIProvider> providers = new ArrayList<UIProvider>();
        for (UIProvider provider : ServiceLoader.load(UIProvider.class)) {
            if (!this.applicationName.equals(provider.getApplicationName())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("provider detected [" + provider + ']'));
            }
            providers.add(provider);
        }
        log.info((Object)("found " + providers.size() + " ui provider(s) in " + StringUtil.convertTime((long)t0, (long)System.nanoTime()) + " : " + providers));
        return providers.toArray(new UIProvider[providers.size()]);
    }

    protected DialogUIDef<?, ?, ?>[] getDefs() {
        return this.defs;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public <M extends DialogUIModel, U extends DialogUI<H>, H extends DialogUIHandler<M, U>> U getUI(DialogUIDef<M, U, H> uiType, Object ... params) {
        Object ui = uiType.uiInstance;
        if (ui == null) {
            try {
                ui = uiType.newUI();
                M model = uiType.newModel();
                H handler = uiType.newHandler(ui, model, params);
                this.registerUI(uiType, (U)ui, handler);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not instanciate ui handler " + uiType + " for reason : " + e.getMessage(), e);
            }
        }
        return ui;
    }

    protected <M extends DialogUIModel, U extends DialogUI<H>, H extends DialogUIHandler<M, U>> void registerUI(DialogUIDef<M, U, H> uiType, U ui, H handler) {
        ui.setHandler(handler);
        handler.init();
        uiType.setUiInstance(ui);
        for (FactoryWindowListener listener : (FactoryWindowListener[])this.listeners.getListeners(FactoryWindowListener.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("----- addFactoryWindowListener " + listener + " to " + ui));
            }
            ui.addWindowListener(listener);
        }
    }
}

