package jaxx.runtime.validator.swing.ui;

import org.jdesktop.jxlayer.JXLayer;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorScope;

/** @author chemit */
public class IconValidationUI extends AbstractBeanValidatorUI {

    // The icon to be shown at the layer's corner
    protected static BufferedImage errorIcon;
    protected static BufferedImage warningIcon;
    protected static BufferedImage infoIcon;

    public IconValidationUI(BeanValidatorField field) {
        super(field);
        if (errorIcon == null) {
            errorIcon = prepareIcon(Color.RED);
        }
        if (warningIcon == null) {
            warningIcon = prepareIcon(Color.ORANGE);
        }
        if (infoIcon == null) {
            infoIcon = prepareIcon(Color.GREEN);
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<JComponent> l) {
        super.paintLayer(g2, l);
        // There is no need to take insets into account for this painter
        BeanValidatorScope scope = field.getScope();
        if (scope != null) {
            BufferedImage icon = null;
            switch (scope) {
                case ERROR:
                    icon = errorIcon;
                    break;
                case WARNING:
                    icon = warningIcon;
                    break;
                case INFO:
                    icon = infoIcon;
                    break;
            }
            if (icon != null) {
                g2.drawImage(icon, l.getWidth() - icon.getWidth() - 1, 0, null);
            }
        }
    }

    protected static BufferedImage prepareIcon(Color color) {
        int width = 7;
        int height = 8;
        BufferedImage icon = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g2 = (Graphics2D) icon.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.WHITE);
        g2.drawLine(0, 0, width, height);
        g2.drawLine(0, height, width, 0);
        g2.dispose();
        return icon;
    }
}
