/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: BeanDoubleListDemoHandler.java 2758 2013-11-28 10:58:35Z tchemit $
 * $HeadURL: https://nuiton.org/svn/jaxx/tags/jaxx-2.8.1/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/BeanDoubleListDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Predicate;
import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.Movie;
import jaxx.demo.entities.People;
import jaxx.runtime.spi.UIHandler;
import org.nuiton.decorator.JXPathDecorator;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.util.List;

/** @author kmorin */
public class BeanDoubleListDemoHandler implements UIHandler<BeanDoubleListDemo> {

    private BeanDoubleListDemo ui;

    @Override
    public void beforeInit(BeanDoubleListDemo ui) {
        this.ui = ui;
    }

    @Override
    public void afterInit(BeanDoubleListDemo ui) {
        DemoDataProvider demoDataProvider = new DemoDataProvider();
        List<People> data = demoDataProvider.getPeoples();
        JXPathDecorator<People> decorator = (JXPathDecorator<People>) new DemoDecoratorProvider().getDecoratorByType(People.class);
        ui.getDoubleList().init(decorator, data, data.subList(0, 1));

        final Movie nacho = demoDataProvider.getMovie("0");
        final Predicate<People> filter = new Predicate<People>() {

            public boolean apply(People input) {
                return nacho.getActors().contains(input);
            }
        };
        ui.getFilterOnNachoButton().addChangeListener(new ChangeListener() {

            public void stateChanged(ChangeEvent e) {
                if (BeanDoubleListDemoHandler.this.ui.getFilterOnNachoButton().isSelected()) {
                    BeanDoubleListDemoHandler.this.ui.getDoubleList().getHandler().addFilter(filter);

                } else {
                    BeanDoubleListDemoHandler.this.ui.getDoubleList().getHandler().clearFilters();
                }
            }
        });
    }
}
