package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: BeanComboBoxDemoHandler.java 2544 2012-12-30 14:33:33Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.9/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/BeanComboBoxDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.People;
import org.nuiton.util.decorator.JXPathDecorator;

import java.util.List;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Handlerof {@link BeanComboBoxDemo}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5.9
 */
public class BeanComboBoxDemoHandler {

    private final BeanComboBoxDemo ui;

    private final JXPathDecorator<People> decorator;

    public BeanComboBoxDemoHandler(BeanComboBoxDemo ui) {
        this.ui = ui;
        this.decorator = (JXPathDecorator<People>)
                new DemoDecoratorProvider().getDecoratorByType(People.class);
    }

    public void init() {
        List<People> data = new DemoDataProvider().getPeoples();

        ui.getComboBox().init(decorator, data);
    }

    public String getSelectedResult(People people) {
        String result;

        if (people == null) {
            result = _("jaxxdemo.beancomboboxdemo.no.people.selected");
        } else {
            result = _("jaxxdemo.beancomboboxdemo.selected.people", decorator.toString(people));
        }
        return result;
    }

    static {
        n_("jaxxdemo.common.people");
        n_("jaxxdemo.common.firstName");
        n_("jaxxdemo.common.lastName");
        n_("jaxxdemo.common.age");
    }
}
