package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * $Id: BeanFilterableComboBoxDemoHandler.java 2704 2013-07-21 10:57:39Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.30/jaxx-demo/src/main/java/jaxx/demo/component/jaxx/editor/BeanFilterableComboBoxDemoHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.People;
import org.nuiton.decorator.JXPathDecorator;

import java.util.List;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

/**
 * Handlerof {@link BeanComboBoxDemo}.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.5.12
 */
public class BeanFilterableComboBoxDemoHandler {

    private final BeanFilterableComboBoxDemo ui;

    private final JXPathDecorator<People> decorator;

    public BeanFilterableComboBoxDemoHandler(BeanFilterableComboBoxDemo ui) {
        this.ui = ui;
        this.decorator = (JXPathDecorator<People>)
                new DemoDecoratorProvider().getDecoratorByType(People.class);
    }

    public void init() {
        List<People> data = new DemoDataProvider().getPeoples();

        ui.getComboBox().init(decorator, data);
    }

    public String getSelectedResult(Object people) {
        String result;

        if (people == null || !People.class.isInstance(people)) {
            result = _("jaxxdemo.beanfilterablecomboboxdemo.no.people.selected");
        } else {
            result = _("jaxxdemo.beanfilterablecomboboxdemo.selected.people", decorator.toString(people));
        }
        return result;
    }

    static {
        n_("jaxxdemo.common.people");
        n_("jaxxdemo.common.firstName");
        n_("jaxxdemo.common.lastName");
        n_("jaxxdemo.common.age");
    }
}
