package jaxx.demo.feature.nav.content;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.demo.entities.Movie;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.renderer.DecoratorProviderListCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MoviesContentUI extends AbstractContentUI<List<Movie>> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_LIST_HEADER_DATA = "listHeader.data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vy04UQRQtRl7DQx6jPAIqCu60B9AYE4wPMATJqATQEGdjdXcBRWqq2qpqaFwYP8FP0L0bE3eujAvXLtwYf8EYF26Nt7pnuh1pho7jLGpm7uPUubfOrXr9DbUpic7u4CCwpM81rRBr+dbGxn17hzj6NlGOpJ4WEkWflhzKlVG3G9uVRpPlkkkvVtOLC6LiCU74H9lzJdSl9D4japsQrdGp+gxHqeJa7J4LPF/WUGNSaagvf3zPvXCfv8ohFHjArhtKmTgqK6mktYRy1NVoEHbaxUWG+RbQkJRvAd9eY1tgWKl7uEKeoGeoo4TaPSwBTKNz2UsOMcL8wNOoMHXLVlpiRy8IriHjwZ1pjS6GpF1SEdYmwdqXxOJ413KiEOuu2KVExQmeF+K1a9TqYo01Om64Wr6mzCpRpRN/59TyCuaEwRaDJiaw1B6UZ0VWE5SPY3unltccKRgzPkgYrktIXCa8L2HAYEONBuqCDQnjH4zDOrQQzMZSoxN1ketgnsfyIOMZ83/ALCOxLz+1PO9rLTiwK9TBRGYTNnYwOoQ6c4hzNsXZZWpaItglsnY0NT1F+xGXwglbNsHcmoelFMdXCUs0VpcGArcSgScKbCmjNumDWaOR8sGZWAVXNA0jf02DAQy9v4YKn999fbtYG4EC7H0yNfSPCQZpelJ4UB41W/dF+jf6Kd7F3lwZ5RVhMP7heI+nEFuruoEc7DeQyG8Jq22AaOv48v7D0ONPx1BuEdopsLuITfwdlNfbErogmBt4N26GjHr2OmHtN9w0amd4X8DJoOPXjLYnbMpdaPn1AJowntKEmImd//izsPbmZq0RLUBs9NDwpBltj1A75YxyEt4G1UFPnf5uTxHfFclAp414i/nu96qKvhCu06mV2kJWFXMp8M3X5ZC2+XUlRClkQOl3BPMrPFLfQ0r2msQb3RaSPoWbBrNo5GE6VwSjzn6TwMO7Rm7O/4btcQhjq4RD9Q17OZQBK78JStXYZjCig9ciUUxgDS+C7WtyPR149EhgY55tQK15hPEMxXUQbipzG8CczgDTqkkQ3u3r/4phzJsNEM5mQsAN6phsmsPRCNW3twGL8xkwuujMVb4iySYNGrDJghS+w02yycO9vLdKFGl0wFmAOs3LuL7vkSMI/QYn4Q3OfgoAAA==";
    private static final Log log = LogFactory.getLog(MoviesContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Movie> data;
    protected JList list;
    protected BeanListHeader<Movie> listHeader;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MoviesContentUI $AbstractContentUI0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        getHandler().initUI(this);    
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MoviesContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MoviesContentUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public MoviesContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MoviesContentUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MoviesContentUI() {
        $initialize();
    }

    public MoviesContentUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public MoviesContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MoviesContentUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().selectChild(this, (Movie) list.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<Movie> getData() {
        return data;
    }

    public JList getList() {
        return list;
    }

    public BeanListHeader<Movie> getListHeader() {
        return listHeader;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(List<Movie> data) {
        List<Movie> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add($JPanel1, BorderLayout.CENTER);
        toolbar.add(listHeader, BorderLayout.EAST);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListHeader() {
        $objectMap.put("listHeader", listHeader = new BeanListHeader<Movie>());
        
        listHeader.setName("listHeader");
        listHeader.setI18nPrefix("jaxxdemo.common.");
        listHeader.setShowReset(true);
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setLayout(new BorderLayout());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $AbstractContentUI0
        add($JPanel0);
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        addChildrenToToolbar();
        // inline complete setup of $JPanel1
        $JPanel1.add($JButton0);
        $JPanel1.add($JButton1);
        $JPanel1.add($JButton2);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        $JScrollPane0.setBorder(new TitledBorder(t("jaxxdemo.navigation.movies.title")));
        $JScrollPane0.setColumnHeaderView(toolbar);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        list.setCellRenderer(getContextValue(DecoratorProviderListCellRenderer.class));
        listHeader.setList(list);
        listHeader.setBeanType(Movie.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AbstractContentUI0", $AbstractContentUI0);
        createData();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        createToolbar();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("jaxxdemo.action.show"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("jaxxdemo.action.add"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("jaxxdemo.action.remove"));
        createListHeader();
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton0.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON0_ENABLED));
                }
            }
        
            public void $pr$u0(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON2_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    $JButton2.setEnabled(list.getSelectedIndex()!=-1);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (list != null) {
                    ListSelectionModel $target = (ListSelectionModel) $bindingSources.remove("list.getSelectionModel()");
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u1"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.feature.nav.content.MoviesContentUI.this, BINDING_$JBUTTON2_ENABLED));
                }
            }
        
            public void $pr$u1(ListSelectionEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_HEADER_DATA, true ,"data") {
        
            @Override
            public void processDataBinding() {
                listHeader.setData(getData());
            }
        });
    }

}
