package jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class JRadioButtonMenuItemDemo extends JMenuItemDemo {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEMO_MESSAGE_FONT = "demoMessage.font";
    public static final String BINDING_DEMO_MESSAGE_TEXT = "demoMessage.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWPW8TQRAdmzhfDiTEwQoQkAkpKNA5BESTKN8KJLJBipsIN6x9i33R+W7Z3UuOFIifwE+AngaJjgpRUFPQIP4CQhS0iNk722eTy/mkc3G2Z9+8eTOat/a7n5ARHG4cEtfVuGNJo0W1vY2Dg8e1Q1qX21TUucGkzcF/pdKQrkJW78aFhJvVkkovttOLW3aL2Ra1erKXSzAu5AuTiialUsK1/oy6EMVK93jZZQ7vsHZFhbG++f0r/Vp/9TYN4DJUN46tFAZlBZ0MlSBt6BKmsdIRKZrEaqAMblgN1HtexbZMIsQj0qLP4SWMlGCYEY5kEubjt+xxePkukzC5sFemlrMraWubtuxFCUueYB2/aPUOjSaOUYW2t090w950pLSt3izGPMJhCSMtDG8SLmFG6XU7iWU/3AP062K9i6eACjLRReYXwspiYqEvMQSjCCYH8NxRpzNxkEuxkXdjI++FILNq9GUqBGlQ3IW+JkukRs1giKPPbEtWjBPEzfetWRuOvvHrPeC2wzCPw9U+HC66Fix6sImpKmS4g2EJs9XT3tjHI98Vs/+5QhF6p3/zuW8ff3zY6VhhBmtfCoX2OBlXlHGbUS4NVXrS94EjDbNYJmy5CmOCmngNeDafCxFWaR+jOKznbZam0rWHRDSRIjPy/dPn/NOv5yC9A+OmTfQdovC7MCabHKdgm7rL1tY9RRPHo/icUtokDEnqos+mVwzLNCxaIBKNWXMkXXVxDHMhY+hqqY19+ZOrvF/vjCKF0i6fCQ/GkXkCw341715oWz70HsgyQR3dDqwdZvaUep9i7fW55T1vh/WarQVLo0BF17PkoqddfVryqHIDqVRYS8QgIXNETAd388KKTiQp1AxLx91eTSLpfoSkfAxJo/4WUj0Rz6DhxGNYU4/1JAxR05hN3EU8hqgu4jFEdXElcRfxGKK6iMcQ1cVc4i7iMUR1MZgBb0r1oxTBcT0GR65pc+MEeYi5YRoNC/9VyIjGBlN2RxMh6h9zpBUufAoAAA==";
    private static final Log log = LogFactory.getLog(JRadioButtonMenuItemDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JAXXButtonGroup fontSize;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JRadioButtonMenuItemDemo $JMenuItemDemo0 = this;
    private JRadioButtonMenuItem $JRadioButtonMenuItem0;
    private JRadioButtonMenuItem $JRadioButtonMenuItem1;
    private JRadioButtonMenuItem $JRadioButtonMenuItem2;
    private JRadioButtonMenuItem $JRadioButtonMenuItem3;
    private JRadioButtonMenuItem $JRadioButtonMenuItem4;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Font updateFont(Object selectedValue) {
        return UIManager.getFont("Label.font").deriveFont(selectedValue != null ? (float) ((Integer) selectedValue).intValue() : 12);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JRadioButtonMenuItemDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JRadioButtonMenuItemDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JRadioButtonMenuItemDemo() {
        $initialize();
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JRadioButtonMenuItemDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JRadioButtonMenuItemDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JAXXButtonGroup getFontSize() {
        return fontSize;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem0() {
        return $JRadioButtonMenuItem0;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem1() {
        return $JRadioButtonMenuItem1;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem2() {
        return $JRadioButtonMenuItem2;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem3() {
        return $JRadioButtonMenuItem3;
    }

    protected JRadioButtonMenuItem get$JRadioButtonMenuItem4() {
        return $JRadioButtonMenuItem4;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMenuBar() {
        if (!allComponentsCreated) {
            return;
        }
        menuBar.add($JMenu0);
    }

    @Override
    protected void createDemoMessage() {
        super.createDemoMessage();
        demoMessage.setName("demoMessage");
        demoMessage.setHorizontalAlignment(0);
    }

    protected void createFontSize() {
        $objectMap.put("fontSize", fontSize = new JAXXButtonGroup());
    }

    @Override
    protected void createMenuBar() {
        super.createMenuBar();
        menuBar.setName("menuBar");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMenuBar();
        // inline complete setup of $JMenu0
        $JMenu0.add($JRadioButtonMenuItem0);
        $JMenu0.add($JRadioButtonMenuItem1);
        $JMenu0.add($JRadioButtonMenuItem2);
        $JMenu0.add($JRadioButtonMenuItem3);
        $JMenu0.add($JRadioButtonMenuItem4);
        // inline complete setup of $JRadioButtonMenuItem0
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem0); }
        
        // inline complete setup of $JRadioButtonMenuItem1
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem1); }
        
        // inline complete setup of $JRadioButtonMenuItem2
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem2.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem2); }
        
        // inline complete setup of $JRadioButtonMenuItem3
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem3.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem3); }
        
        // inline complete setup of $JRadioButtonMenuItem4
        { ButtonGroup $buttonGroup = fontSize; $JRadioButtonMenuItem4.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButtonMenuItem4); }
        
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        { $JRadioButtonMenuItem0.putClientProperty("$value", 10);  Object $buttonGroup = $JRadioButtonMenuItem0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem1.putClientProperty("$value", 12);  Object $buttonGroup = $JRadioButtonMenuItem1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem2.putClientProperty("$value", 14);  Object $buttonGroup = $JRadioButtonMenuItem2.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem3.putClientProperty("$value", 18);  Object $buttonGroup = $JRadioButtonMenuItem3.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButtonMenuItem4.putClientProperty("$value", 24);  Object $buttonGroup = $JRadioButtonMenuItem4.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JMenuItemDemo0", $JMenuItemDemo0);
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("Font size"));
        // inline creation of $JRadioButtonMenuItem0
        $objectMap.put("$JRadioButtonMenuItem0", $JRadioButtonMenuItem0 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem0.setName("$JRadioButtonMenuItem0");
        $JRadioButtonMenuItem0.setText(t("10"));
        // inline creation of $JRadioButtonMenuItem1
        $objectMap.put("$JRadioButtonMenuItem1", $JRadioButtonMenuItem1 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem1.setName("$JRadioButtonMenuItem1");
        $JRadioButtonMenuItem1.setSelected(true);
        $JRadioButtonMenuItem1.setText(t("12"));
        // inline creation of $JRadioButtonMenuItem2
        $objectMap.put("$JRadioButtonMenuItem2", $JRadioButtonMenuItem2 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem2.setName("$JRadioButtonMenuItem2");
        $JRadioButtonMenuItem2.setText(t("14"));
        // inline creation of $JRadioButtonMenuItem3
        $objectMap.put("$JRadioButtonMenuItem3", $JRadioButtonMenuItem3 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem3.setName("$JRadioButtonMenuItem3");
        $JRadioButtonMenuItem3.setText(t("18"));
        // inline creation of $JRadioButtonMenuItem4
        $objectMap.put("$JRadioButtonMenuItem4", $JRadioButtonMenuItem4 = new JRadioButtonMenuItem());
        
        $JRadioButtonMenuItem4.setName("$JRadioButtonMenuItem4");
        $JRadioButtonMenuItem4.setText(t("24"));
        createFontSize();
        // inline creation of $JMenuItemDemo0
        setName("$JMenuItemDemo0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMO_MESSAGE_FONT, true) {
        
            @Override
            public void applyDataBinding() {
                if (fontSize != null) {
                    fontSize.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fontSize != null) {
                    demoMessage.setFont(updateFont(fontSize.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fontSize != null) {
                    fontSize.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMO_MESSAGE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (fontSize != null) {
                    fontSize.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (fontSize != null) {
                    demoMessage.setText(t("Font size: " + (fontSize.getSelectedValue())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (fontSize != null) {
                    fontSize.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
    }

}
