package jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2017 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DemoTab extends JTabbedPane implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SOURCE_TABS_SOURCES = "sourceTabs.sources";
    public static final String BINDING_TAB_DEMO_PANEL_TITLE = "tabDemoPanel.title";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1SPW8TQRAdX7CNnQQSTKIARjIJojz/AEcQFMsiyHwIU0S4Yc+3xBeddze7e+RoED+BnwA9DRIdFaKgpqBB/AWEKGgRs+vznQ8OgYs9a2bemzcz79VXKCsJlw5JHLsyYjqYUPfm9f39O94hHekuVSMZCM0lTH8lB5whLPppXGnYGvYNvJ3A27t8IjijbA7d6UNd6SchVWNKtYaLecRIqfYgTXdiEckZayqqiPXF92/Oc//ZSwcgFqjOjNL6Fyqb5EQfnMDXcAY7PSbtkLADlCEDdoB6l01sNyRK3SYTegRPodqHiiASyTRs/v/IlsPiY6FhQXN8V61In06428XnPvGEsDUVDTUTvksYDTU08nU2aspqaXVd8UiOKDLgJdby5QObUnnAkiZeN+twPrcudYzDu0i2xx7xTNKpBDNHeBazEi7k0HhGNztjtufSEMoywrCGjeGfl7+HqenNN367uSG02Z/rjU9vv7zpzQ7tYO+1wtI5n+IBhOSCSh2Y1qenV450ELZvEdEZQk3REE1uTdwsEDZI0igO+60auGvg7g2ixkhRrn5+93794ccFcHpQDznxe8TU70FNjyVugYd+LK7tWEVLxyfxXTHaNCwHbMQnuGtrDlzwtk80aXkB8zF4NcZdNAt2kQryah9+NAavd2b7KKG+c38tz3ZSfgCVgIUBo9b6iasLrb4oFI18nrm3yM8l810RiVOa9m0VDVxVmXW24sh8Llvd5t+VlOYXxBuS7I8EAAA=";
    private static final Log log = LogFactory.getLog(DemoTab.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoPanel demoPanel;
    protected DemoSources sourceTabs;
    protected TabInfo tabDemoPanel;
    protected TabInfo tabDemoSources;
    protected DemoTab top = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
        SwingUtilities.invokeLater(new Runnable() {
    
            @Override
            public void run() {
                if (demoPanel.getSources().length == 0) {
                   top.remove(sourceTabs);
                   return;
                }
                sourceTabs.init();
            }
        });
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoTab(int param0) {
        super(param0);
        $initialize();
    }

    public DemoTab(JAXXContext parentContext, int param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoTab(int param0, int param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoTab(JAXXContext parentContext, int param1, int param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoTab() {
        $initialize();
    }

    public DemoTab(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoPanel getDemoPanel() {
        return demoPanel;
    }

    public DemoSources getSourceTabs() {
        return sourceTabs;
    }

    public TabInfo getTabDemoPanel() {
        return tabDemoPanel;
    }

    public TabInfo getTabDemoSources() {
        return tabDemoSources;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToTop() {
        if (!allComponentsCreated) {
            return;
        }
        add(demoPanel);
        add(sourceTabs);
        tabDemoPanel.addPropertyChangeListener(new TabInfoPropertyChangeListener(top, 0));
        tabDemoSources.addPropertyChangeListener(new TabInfoPropertyChangeListener(top, 1));
        top.setTitleAt(1, t("Sources"));
    }

    protected void createDemoPanel() {
        $objectMap.put("demoPanel", demoPanel = getContextValue(DemoPanel.class, "content"));
        
        demoPanel.setName("demoPanel");
    }

    protected void createSourceTabs() {
        $objectMap.put("sourceTabs", sourceTabs = new DemoSources(demoPanel));
        
        sourceTabs.setName("sourceTabs");
    }

    protected void createTabDemoPanel() {
        $objectMap.put("tabDemoPanel", tabDemoPanel = new TabInfo());
    }

    protected void createTabDemoSources() {
        $objectMap.put("tabDemoSources", tabDemoSources = new TabInfo());
        
        tabDemoSources.setTitle(t("Sources"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        sourceTabs.setIncomingClass(demoPanel.getClass());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createDemoPanel();
        createSourceTabs();
        createTabDemoPanel();
        createTabDemoSources();
        // inline creation of top
        setName("top");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAB_DEMO_PANEL_TITLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoPanel != null) {
                    demoPanel.addPropertyChangeListener("demoTabTitle", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoPanel != null) {
                    tabDemoPanel.setTitle(demoPanel.getDemoTabTitle());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoPanel != null) {
                    demoPanel.removePropertyChangeListener("demoTabTitle", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_TABS_SOURCES, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoPanel != null) {
                    demoPanel.addPropertyChangeListener("sources", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoPanel != null) {
                    sourceTabs.setSources(Arrays.asList(demoPanel.getSources()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoPanel != null) {
                    demoPanel.removePropertyChangeListener("sources", this);
                }
            }
        });
    }

}
