package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SimpleTimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TMW/TQBR+cZukSYAChaioRSolQqJCDgMLCoKilgiiFBDpUJGFc+5IXF3sw3em7oL4CfwE2FmQ2JgQAzMDC+IvIMTAinh3SewaXFqRwbbeve9733353utvkJcBnNsmUWQHoafcIbNbN7e27jnbrKfWmewFrlB+AKNfzgKrCxUa16WC8922htfH8PqaPxS+x7w96EYbylLtciYHjCkFZ9OInpT1TnzciEQYTFhjUVmsL398t17Q568sgEiguiJeZekgVHKT6TZYLlVwEic9JXVOvD7KCFyvj3qP6toaJ1LeJUP2BJ5BsQ0FQQIkU7B8+CsbDoOPhIJKbZ0N/fvEY/yygitGLMWK3ZtQ2KbGqIskdscdCs42ccYtU9BgIQxdQUFJIzd8yriCq/9DZbAJX7G2SRzOUNh8ykW5g57Y5kx3lmJAped7j92+uQ76qC2Lxt0tU9R9s3F7YSRFwUoG/T4y0wzlgMmQK82tK6fSpzO1Vps4xtm0FlPVTfMCI7KQmo7hs5PwJenIdSEfhFhGN7p/5/UBHo2SOv9HUjWhOf1Vnfv87uvb5iSeUzj7dGbrnu3C2IjAFyxQrh49O8pmqFxe3yCi0YWSZBxX06zeYoawzvgYxeG8Expua7h9m8gBUuSLX95/qD76NAVWE8rcJ7RJdP8dKKkB2jvwOY3EjVWj6MjODD6Pa23493Gy64eY/mPXKFFkyXE9ivZej9CExQwTYiVO6ePPuc6b1YkRORR2Zt/2xIz8Qyi4Hnc9ZjZ1vISZm1kRkoXUT5Yta/1y+l0W48Avm+eFzJs6fkCZyd7FKNSvFSNbf10yLNVDsEwrFql/cCwgx2/Vgc0/gQUAAA==";
    private static final Log log = LogFactory.getLog(SimpleTimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configPanel;
    protected SimpleTimeEditorDemoModel demoModel;
    protected SimpleTimeEditor editor;
    protected final SimpleTimeEditorDemoHandler handler = createHandler();
    protected JPanel resultPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SimpleTimeEditorDemo $DemoPanel0 = this;
    private JLabel $JLabel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SimpleTimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SimpleTimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SimpleTimeEditorDemo() {
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public SimpleTimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigPanel() {
        return configPanel;
    }

    public SimpleTimeEditorDemoModel getDemoModel() {
        return demoModel;
    }

    public SimpleTimeEditor getEditor() {
        return editor;
    }

    public SimpleTimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JPanel getResultPane() {
        return resultPane;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToResultPane() {
        if (!allComponentsCreated) {
            return;
        }
        resultPane.add($JLabel0, BorderLayout.CENTER);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new JPanel());
        
        configPanel.setName("configPanel");
    }

    protected void createDemoModel() {
        $objectMap.put("demoModel", demoModel = new SimpleTimeEditorDemoModel());
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new SimpleTimeEditor(this));
        
        editor.setName("editor");
    }

    protected SimpleTimeEditorDemoHandler createHandler() {
        return new SimpleTimeEditorDemoHandler();
    }

    protected void createResultPane() {
        $objectMap.put("resultPane", resultPane = new JPanel());
        
        resultPane.setName("resultPane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(configPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(resultPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToResultPane();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        editor.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.editor")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createDemoModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigPanel();
        createEditor();
        createResultPane();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (demoModel != null) {
                    demoModel.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (demoModel != null) {
                    $JLabel0.setText(t(t("jaxxdemo.timeeditor.value", demoModel.getTime())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (demoModel != null) {
                    demoModel.removePropertyChangeListener("time", this);
                }
            }
        });
    }

}