package jaxx.demo.component.jaxx.widgets.datetime;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.datetime.TimeEditor;
import static org.nuiton.i18n.I18n.t;

public class TimeEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_LABEL = "editor.label";
    public static final String BINDING_EDITOR_TIME = "editor.time";
    public static final String BINDING_RESULT_TIME_TEXT = "resultTime.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzW8bRRR/dmPnw4F8VElLW0TqVqojqnUQFaoIhZKUlFYuVE0OVX1h7Jna245ntzOzzUZuEX8CfwLcuSBx44Q4cObABfEvIMShV8SbGXu9G29lq7XkWft9v9+899sf/oaSknD+EYljT0ZC+z3m3f70/v0vW49YW99gqi39UAcS3KdQhGITKjSRKw0Xmg3jXh+413eDXhgIJlLe2w1YUPqIM9VlTGt4O+vRVqq+n6i34zCSw6hJUXlRv/v3n+K39JvviwBxiNVVsJWNSV6jTmYaUPSphlXM9JTUOREdLEP6ooP1vmFku5wo9QXpsSfwNcw2oBwSicE0VKdv2caw/nGooXLxBusFd4lgfEvDVVssRYnXHobwrOzQpx2mlUeJZraTAzw+oz5GNgHC0IYsayj1Asq4hmuvGuqO8R/Fm7t4e1jdqoEg9tQhIuI5qTGaT2wr7UA89DtWo+F0BnnndUBa3IK3lDgtc9JifNd6NszP44ms0BivjhKlfDSsZ8wPWKz3fMZp1mWRCZN7J9I6EBrWMj67XdZ+vBPEWZcys6BoeDeQHU9E+EdMhDDbXFkyFXFt/q1ksVpyGuOYNHjKHOcTk4WRiZGcGWglnM0gi9vijbZlNM6FJpRkhGK8iub4gt1DlVut08dWywS02v/WT/7x818/7aX3aS3XNEUHOOehDEImtW9SL7llirTP63dIuN2EecU4conlinM5he0P1Fgc5lsx7p5x9z4nqoshSrN//vLr+le/n4DiHizwgNA9YuxvwbzuImTdgNM4/OS6rWjxcA7PZfwW8TZagaRYGHzYF+xw48DXnNEdK6vpWtVUYhfGlOLu3nMTHUmi/UBUNzefYxROjgIcI1izUW5KnzaspLZ1+b3N5zEiei4H0aSt1vxvL07u/3h9iGoBu3zrpeYjZEsPoOwL7gtmeWpAQbm8VAkVi2gwopo88oHswoaDnb9sz60x/AoaZjTuloZLE4Hy7H7GkYn0gW3R/LoKOds+fdor/WnuyKX2nhIesaq5jfEa0uwxKX0xSX8mL7UjFWRJN9OMGnMZsby0GQaalLecmtb3p55W93BjujjYwiPDH6as9GOlb18THrKYUdeMQ4k79j3VT+FjLbB/azHTYgS5c9Y5o2DWtYRdn+2nu/N8tT8ApJZ/BwNuneL2XwEGx5sGhtzUTj394L3z8hxWkpfkOL1PMWdzJrIbp9JDwhVLCqj2u0RQzmRyX8duL7/R1PtjGpyHtPbmR/haIxstX1B8OX48FrlgzoWJEY34mTnGa7O65deOUMUI/wP0L3s/sQoAAA==";
    private static final Log log = LogFactory.getLog(TimeEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table configPanel;
    protected TimeEditor editor;
    protected JCheckBox enableButton;
    protected final TimeEditorDemoHandler handler = createHandler();
    protected JTextField labelConfig;
    protected JLabel labelConfigLabel;
    protected TimeEditorDemoModel model;
    protected JPanel result;
    protected JTextField resultTime;
    protected JLabel resultTimeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TimeEditorDemo $DemoPanel0 = this;
    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TimeEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TimeEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TimeEditorDemo() {
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public TimeEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getConfigPanel() {
        return configPanel;
    }

    public TimeEditor getEditor() {
        return editor;
    }

    public JCheckBox getEnableButton() {
        return enableButton;
    }

    public TimeEditorDemoHandler getHandler() {
        return handler;
    }

    public JTextField getLabelConfig() {
        return labelConfig;
    }

    public JLabel getLabelConfigLabel() {
        return labelConfigLabel;
    }

    public TimeEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JTextField getResultTime() {
        return resultTime;
    }

    public JLabel getResultTimeLabel() {
        return resultTimeLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configPanel.add(labelConfigLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(labelConfig, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configPanel.add(enableButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultTimeLabel);
        result.add(resultTime);
    }

    protected void createConfigPanel() {
        $objectMap.put("configPanel", configPanel = new Table());
        
        configPanel.setName("configPanel");
        configPanel.setLayout(new GridLayout(0,1));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new TimeEditor(this));
        
        editor.setName("editor");
        editor.setPropertyTime("time");
    }

    protected void createEnableButton() {
        $objectMap.put("enableButton", enableButton = new JCheckBox());
        
        enableButton.setName("enableButton");
        enableButton.setText(t("jaxxdemo.timeeditor.enable"));
        enableButton.setSelected(true);
    }

    protected TimeEditorDemoHandler createHandler() {
        return new TimeEditorDemoHandler();
    }

    protected void createLabelConfig() {
        $objectMap.put("labelConfig", labelConfig = new JTextField());
        
        labelConfig.setName("labelConfig");
        labelConfig.setColumns(15);
    }

    protected void createLabelConfigLabel() {
        $objectMap.put("labelConfigLabel", labelConfigLabel = new JLabel());
        
        labelConfigLabel.setName("labelConfigLabel");
        labelConfigLabel.setText(t("jaxxdemo.timeeditor.configuration.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TimeEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,2));
    }

    protected void createResultTime() {
        $objectMap.put("resultTime", resultTime = new JTextField());
        
        resultTime.setName("resultTime");
        resultTime.setColumns(15);
        resultTime.setEditable(false);
    }

    protected void createResultTimeLabel() {
        $objectMap.put("resultTimeLabel", resultTimeLabel = new JLabel());
        
        resultTimeLabel.setName("resultTimeLabel");
        resultTimeLabel.setText(t("jaxxdemo.timeeditor.result.time"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($JPanel0, BorderLayout.NORTH);
        add(result, BorderLayout.CENTER);
        // inline complete setup of $JPanel0
        $JPanel0.add(configPanel, BorderLayout.NORTH);
        $JPanel0.add(editor, BorderLayout.CENTER);
        addChildrenToConfigPanel();
        addChildrenToResult();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        configPanel.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.configuration")));
        SwingUtil.setText(labelConfig, t("jaxxdemo.timeeditor.configuration.label.value"));
        
        editor.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.editor")));
        editor.setBean(model);
        result.setBorder(new TitledBorder(t("jaxxdemo.timeeditor.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigPanel();
        createLabelConfigLabel();
        createLabelConfig();
        createEnableButton();
        createEditor();
        createResult();
        createResultTimeLabel();
        createResultTime();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TIME, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setTime(model.getTime());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LABEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (labelConfig != null) {
                    $bindingSources.put("labelConfig.getDocument()", labelConfig.getDocument());
                    labelConfig.getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    labelConfig.addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.TimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (labelConfig != null) {
                    editor.setLabel(labelConfig.getText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (labelConfig != null) {
                    Document $target = (Document) $bindingSources.remove("labelConfig.getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    labelConfig.removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.TimeEditorDemo.this, BINDING_EDITOR_LABEL));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (enableButton != null) {
                    $bindingSources.put("enableButton.getModel()", enableButton.getModel());
                    enableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    enableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.TimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (enableButton != null) {
                    editor.setEnabled(enableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (enableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("enableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    enableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.widgets.datetime.TimeEditorDemo.this, BINDING_EDITOR_ENABLED));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_TIME_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("time", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(resultTime, handler.getTime(model.getTime()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("time", this);
                }
            }
        });
    }

}