package jaxx.demo;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import jaxx.demo.tree.DemoCellRenderer;
import jaxx.demo.tree.DemoTreeHelper;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DemoUI extends JFrame implements JAXXHelpUI<DemoHelpBroker>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_ICON_IMAGE = "mainFrame.iconImage";
    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoHelpBroker broker;
    protected DemoConfig config;
    protected JPanel content;
    protected CardLayout2 contentLayout;
    protected final DemoUIHandler handler = createHandler();
    protected DemoUI mainFrame = this;
    protected JPanel mainPane;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileFullscreen;
    protected JMenu menuFileLanguage;
    protected JMenuItem menuFileLanguageFR;
    protected JMenuItem menuFileLanguageUK;
    protected JMenuItem menuFileNormalscreen;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpLogs;
    protected JMenuItem menuHelpSite;
    protected JTree navigation;
    protected JScrollPane navigationPane;
    protected StatusMessagePanel p;
    protected JButton showHelp;
    protected JSplitPane splitPane;
    protected DemoTreeHelper treeHelper;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpLogs(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showLogs(this);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoHelpBroker getBroker() {
        return broker;
    }

    public DemoConfig getConfig() {
        return config;
    }

    public JPanel getContent() {
        return content;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPane() {
        return mainPane;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpLogs() {
        return menuHelpLogs;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JTree getNavigation() {
        return navigation;
    }

    public JScrollPane getNavigationPane() {
        return navigationPane;
    }

    public StatusMessagePanel getP() {
        return p;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public DemoTreeHelper getTreeHelper() {
        return treeHelper;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(DemoHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(splitPane, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
        menu.add($JToolBar0);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpLogs);
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void addChildrenToNavigationPane() {
        if (!allComponentsCreated) {
            return;
        }
        navigationPane.getViewport().add(navigation);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(navigationPane, JSplitPane.LEFT);
        splitPane.add(content, JSplitPane.RIGHT);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new DemoHelpBroker("ui.main.menu"));
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContent() {
        $objectMap.put("content", content = new JPanel());
        
        content.setName("content");
        content.setLayout(contentLayout);
        content.putClientProperty("help", "ui.main.body.db.view.content");
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
        
        contentLayout.setUseOnlyVisibleComponentDimension(true);
    }

    protected DemoUIHandler createHandler() {
        return new DemoUIHandler();
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("jaxxdemo.menu.file"));
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(t("jaxxdemo.action.configuration"));
        menuFileConfiguration.setToolTipText(t("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("jaxxdemo.action.exit"));
        menuFileExit.setToolTipText(t("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(t("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setToolTipText(t("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setToolTipText(t("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(t("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setToolTipText(t("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(t("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setToolTipText(t("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(t("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(t("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(t("jaxxdemo.menu.help"));
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(t("jaxxdemo.action.about"));
        menuHelpAbout.setToolTipText(t("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(t("jaxxdemo.action.help"));
        menuHelpHelp.setToolTipText(t("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpLogs() {
        $objectMap.put("menuHelpLogs", menuHelpLogs = new JMenuItem());
        
        menuHelpLogs.setName("menuHelpLogs");
        menuHelpLogs.setText(t("jaxxdemo.action.showLogs"));
        menuHelpLogs.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpLogs"));
        menuHelpLogs.putClientProperty("help", "ui.main.action.showLogs");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(t("jaxxdemo.action.site"));
        menuHelpSite.setToolTipText(t("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createNavigation() {
        $objectMap.put("navigation", navigation = new JTree());
        
        navigation.setName("navigation");
        navigation.setLargeModel(true);
        navigation.setShowsRootHandles(false);
        if (navigation.getFont() != null) {
            navigation.setFont(navigation.getFont().deriveFont((float) 11));
        }
        navigation.setRootVisible(false);
    }

    protected void createNavigationPane() {
        $objectMap.put("navigationPane", navigationPane = new JScrollPane());
        
        navigationPane.setName("navigationPane");
    }

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setBorderPainted(false);
        showHelp.setVisible(true);
        showHelp.setToolTipText(t("jaxxdemo.action.showHelp.tip"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerSize(6);
    }

    protected void createTreeHelper() {
        $objectMap.put("treeHelper", treeHelper = getContextValue(DemoTreeHelper.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(showHelp, BorderLayout.EAST);
        addChildrenToMainPane();
        addChildrenToSplitPane();
        addChildrenToNavigationPane();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 32 property setters
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.configuration.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileLanguage.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.file.locale.mnemonic"),'Z'));
        menuFileLanguage.setIcon(SwingUtil.createActionIcon("translate"));
        menuFileLanguageFR.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.fr.mnemonic"),'Z'));
        menuFileLanguageFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageUK.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.locale.uk.mnemonic"),'Z'));
        menuFileLanguageUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuFileFullscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.fullscreen.mnemonic"),'Z'));
        menuFileFullscreen.setIcon(SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.normalscreen.mnemonic"),'Z'));
        menuFileNormalscreen.setIcon(SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.exit.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.menu.help.mnemonic"),'Z'));
        menuHelpLogs.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.showLogs.mnemonic"),'Z'));
        menuHelpHelp.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.help.mnemonic"),'Z'));
        menuHelpHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.site.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(t("jaxxdemo.action.about.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        navigationPane.setBorder(null);
        navigationPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        navigationPane.setMinimumSize(new Dimension(230,0));
        navigation.setCellRenderer(new DemoCellRenderer(getTreeHelper().getDataProvider()));
        navigation.setModel(getTreeHelper().createModel());
        // late initializer
        // help broker setup
        DemoHelpBroker _broker = getBroker();
        registerHelpId(_broker, menu, "ui.main.menu");
        registerHelpId(_broker, menuFile, "ui.main.menu.file");
        registerHelpId(_broker, menuFileConfiguration, "ui.main.menu.file.configuration");
        registerHelpId(_broker, menuFileLanguage, "ui.main.menu.file.locale");
        registerHelpId(_broker, menuFileLanguageFR, "ui.main.menu.file.locale.fr");
        registerHelpId(_broker, menuFileLanguageUK, "ui.main.menu.file.locale.uk");
        registerHelpId(_broker, menuFileFullscreen, "ui.main.menu.file.fullscreen");
        registerHelpId(_broker, menuFileNormalscreen, "ui.main.menu.file.leave-fullscreen");
        registerHelpId(_broker, menuFileExit, "ui.main.menu.file.exit");
        registerHelpId(_broker, menuHelp, "ui.main.menu.help");
        registerHelpId(_broker, menuHelpLogs, "ui.main.action.showLogs");
        registerHelpId(_broker, menuHelpHelp, "ui.main.menu.help.help");
        registerHelpId(_broker, menuHelpSite, "ui.main.menu.help.site");
        registerHelpId(_broker, menuHelpAbout, "ui.main.menu.help.about");
        registerHelpId(_broker, content, "ui.main.body.db.view.content");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createContentLayout();
        createConfig();
        createTreeHelper();
        createBroker();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpLogs();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setLayout(new BorderLayout());
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setOpaque(false);
        $JToolBar0.setFloatable(false);
        createShowHelp();
        createMainPane();
        createSplitPane();
        createNavigationPane();
        createNavigation();
        createContent();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_ICON_IMAGE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("iconPath", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setIconImage(SwingUtil.createIcon(getConfig().getIconPath()).getImage());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("iconPath", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}