package jaxx.demo.component.jaxx.editor.gis;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import static org.nuiton.i18n.I18n.t;

public class CoordinatesEditorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_LATITUDE = "editor.latitude";
    public static final String BINDING_EDITOR_LONGITUDE = "editor.longitude";
    public static final String BINDING_EDITOR_QUADRANT = "editor.quadrant";
    public static final String BINDING_EDITOR_SHOW_RESET_BUTTON = "editor.showResetButton";
    public static final String BINDING_RESULT_LATITUDE_TEXT = "resultLatitude.text";
    public static final String BINDING_RESULT_LONGITUDE_TEXT = "resultLongitude.text";
    public static final String BINDING_RESULT_QUADRANT_TEXT = "resultQuadrant.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW8TRxh+48bOFyVAmoiKoIaUQ1KVNQipUpWKj4RGFBloCQdUXzr2DvbQ8cwyM1tvFKXiJ/QntHcuSL31VPXAuQcuiL+Aqh56Rbwzu5712tvGoj6s1+/H834+r5++hqpWcO4RSZJAxcKwHg1uXX/w4G7rEW2bG1S3FYuMVJB+pipQacJC6OXawMfNhnWvZ+71HdmLpKBiyHurAfPa7HOqu5QaA2eLHm2t63tevZVEsRqg+qTKUH/++6/KT+GTXyoASYTZzWMpa0d55ZVMN6DCQgOnMNIPpM6J6GAaiokO5vu+le1wovUd0qOP4UeYaUAtIgrBDKxPXrLDcP5JZGDh/A3ak18TQflFA5+7ZEOUBO0BROBkNGQIEnSYxhqkCpkghuovndQiRJHDrBmo9mRIuYEr74x12wLkgDPn75MWp5je6UIvdR87EzidtZzzDrW2FA9ZBxtpe5ZkhrdckdZk0VvO6a7s36Pa7sBywXinS9vfb8vEGp7KkdPUDXwmVScQMf4QaU19Fnao0a4o0tKSx4aOV1eMXlNUx9zYXx8UNcdTzTcxCRWx8y1W0iCttJIzox4NYpiJQ9eQj4oWi5mFFJ0xEwVnCq1FAgQ5AfINnWpCVcUoxlk0xzlzD1UpW06PsMUCOu2blaUXv736dXeYIsulpkMMx9WNlIyoMsyGXkz5ERvG67dJtNXEOVKO58HRf7Uksb1MjclhvJPWPbDuwU2iuwhRnXn5+x8r3/35HlR2YZ5LEu4Sa/8VzJku9q0reZhEV6+5jI71Z/F5wuaGM2zhiDExuH4gaH/tPjOchttOtmE21m0mGQVGViFIlzRWODEp1jc3DxPs22pJ33zyrbnn/yztPbs26N0U1vLhv5rn/at+CzUmOBPUHZjsdpQelIVI0ziU+Y0ouxrgKRZlLN10zwtjDaoYmE1HQ/GuTRsVU/tFE3tzS3oTeD4msUW85Kq0b5dhmK1HxZ01cDLbmH2/8AjA8/cTXp9RBlPl/nW6RZF3MHPgjtlh0XUllQZIeA++sXlYAFgessmEqcljz+khkwHRnYnPLKf/kNeib8J2bPD8IBMPvChgei9r94ZdqPEeZhfsqAYOb/blSTc7SC9MussloVP1BKGzDfnkoEtEyKkqtKikaeXxRo7oO8b10yuZ53/GHZhNHvfTQly/WWXLVh559MRPMmVO9iUuEhz/IiSGrLWYwGF2rozBT9nn/JGIVuz+5nQ5wtL/RlhFhLd6OYB+JwoAAA==";
    private static final Log log = LogFactory.getLog(CoordinatesEditorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel config;
    protected CoordinatesEditor editor;
    protected final CoordinatesEditorDemoHandler handler = new CoordinatesEditorDemoHandler();
    protected CoordinatesEditorDemoModel model;
    protected JPanel result;
    protected JLabel resultLatitude;
    protected JLabel resultLongitude;
    protected JLabel resultQuadrant;
    protected JCheckBox showReset;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private CoordinatesEditorDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CoordinatesEditorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public CoordinatesEditorDemo() {
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CoordinatesEditorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public CoordinatesEditorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfig() {
        return config;
    }

    public CoordinatesEditor getEditor() {
        return editor;
    }

    public CoordinatesEditorDemoHandler getHandler() {
        return handler;
    }

    public CoordinatesEditorDemoModel getModel() {
        return model;
    }

    public JPanel getResult() {
        return result;
    }

    public JLabel getResultLatitude() {
        return resultLatitude;
    }

    public JLabel getResultLongitude() {
        return resultLongitude;
    }

    public JLabel getResultQuadrant() {
        return resultQuadrant;
    }

    public JCheckBox getShowReset() {
        return showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfig() {
        if (!allComponentsCreated) {
            return;
        }
        config.add(showReset);
    }

    protected void addChildrenToResult() {
        if (!allComponentsCreated) {
            return;
        }
        result.add(resultQuadrant);
        result.add(resultLatitude);
        result.add(resultLongitude);
    }

    protected void createConfig() {
        $objectMap.put("config", config = new JPanel());
        
        config.setName("config");
        config.setLayout(new GridLayout(1,0));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new CoordinatesEditor());
        
        editor.setName("editor");
        editor.setPropertyLatitude("latitude");
        editor.setPropertyLongitude("longitude");
        editor.setPropertyQuadrant("quadrant");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CoordinatesEditorDemoModel.class));
    }

    protected void createResult() {
        $objectMap.put("result", result = new JPanel());
        
        result.setName("result");
        result.setLayout(new GridLayout(0,1));
    }

    protected void createResultLatitude() {
        $objectMap.put("resultLatitude", resultLatitude = new JLabel());
        
        resultLatitude.setName("resultLatitude");
    }

    protected void createResultLongitude() {
        $objectMap.put("resultLongitude", resultLongitude = new JLabel());
        
        resultLongitude.setName("resultLongitude");
    }

    protected void createResultQuadrant() {
        $objectMap.put("resultQuadrant", resultQuadrant = new JLabel());
        
        resultQuadrant.setName("resultQuadrant");
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = new JCheckBox());
        
        showReset.setName("showReset");
        showReset.setText(t("jaxxdemo.coordinate.showReset"));
        showReset.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.NORTH);
        // inline complete setup of $Table0
        $Table0.add(config, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(result, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToConfig();
        addChildrenToResult();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        config.setBorder(new TitledBorder(t("jaxxdemo.coordinatesEditor.configuration")));
        editor.setBean(model);
        result.setBorder(new TitledBorder(t("jaxxdemo.coordinate.result")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfig();
        createShowReset();
        createEditor();
        createResult();
        createResultQuadrant();
        createResultLatitude();
        createResultLongitude();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LONGITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLongitude(model.getLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_LATITUDE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setLatitude(model.getLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_SHOW_RESET_BUTTON, true) {
        
            @Override
            public void applyDataBinding() {
                if (showReset != null) {
                    $bindingSources.put("showReset.getModel()", showReset.getModel());
                    showReset.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    showReset.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showReset != null) {
                    editor.setShowResetButton(showReset.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showReset != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showReset.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    showReset.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.gis.CoordinatesEditorDemo.this, BINDING_EDITOR_SHOW_RESET_BUTTON));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_QUADRANT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setQuadrant(model.getQuadrant());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_QUADRANT_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quadrant", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultQuadrant.setText(t(handler.getQuadrant(model.getQuadrant())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quadrant", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LATITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("latitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLatitude.setText(t(handler.getLatitude(model.getLatitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("latitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESULT_LONGITUDE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("longitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resultLongitude.setText(t(handler.getLongitude(model.getLongitude())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("longitude", this);
                }
            }
        });
    }

}