package org.nuiton.jaxx.application.swing.util;

/*
 * #%L
 * JAXX :: Application Swing
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.util.PaintUtils;

import java.awt.Color;
import java.awt.Component;

/**
 * @author Tony Chemit - chemit@codelutin.com
 * @since 2.8
 */
public class ApplicationColorHighlighter extends AbstractHighlighter {

    protected Color color;

    protected boolean foreground;

    public ApplicationColorHighlighter(HighlightPredicate predicate, Color color, boolean foreground) {
        super(predicate);
        this.color = color;
        this.foreground = foreground;
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {

        if (foreground) {
            component.setForeground(color);

        } else {
            component.setBackground(color);
            if (adapter.isSelected()) {
                component.setForeground(PaintUtils.computeForeground(color));
            }
        }

        return component;
    }
}
