/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.plugin.PluginIOContext;
import org.nuiton.plugin.PluginWithEncoding;

public class PluginHelper {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    protected static final double[] timeFactors = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    protected static final String[] timeUnites = new String[]{"ns", "ms", "s", "m", "h", "d"};
    protected static final double[] memoryFactors = new double[]{1024.0, 1024.0, 1024.0, 1024.0};
    protected static final String[] memoryUnites = new String[]{"o", "Ko", "Mo", "Go", "To"};

    public static String removeSnapshotSuffix(String versionId) {
        if (versionId.endsWith(SNAPSHOT_SUFFIX)) {
            versionId = versionId.substring(0, versionId.length() - SNAPSHOT_SUFFIX.length());
        }
        return versionId;
    }

    public static <O> List<O> toGenericList(List<?> list, Class<O> type) throws IllegalArgumentException {
        if (list.isEmpty()) {
            return list;
        }
        for (Object o : list) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("can not cast List with object of type " + o.getClass() + " to " + type + " type!");
        }
        return list;
    }

    public static String convertMemory(long value) {
        return PluginHelper.convert(value, memoryFactors, memoryUnites);
    }

    public static String convertTime(long value) {
        return PluginHelper.convert(value, timeFactors, timeUnites);
    }

    public static String convertTime(long value, long value2) {
        return PluginHelper.convertTime(value2 - value);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static String[] splitAndTrim(String txt, String separator) {
        String[] result = txt.split(separator);
        int j = result.length;
        for (int i = 0; i < j; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prefixLines(String prefix, String prefixForEmpty, String content) throws IOException {
        BufferedReader reader = null;
        reader = new BufferedReader(new StringReader(content));
        try {
            String result;
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) {
                    sb.append(prefixForEmpty);
                } else {
                    sb.append(prefix);
                    sb.append(line);
                }
                if ((line = reader.readLine()) == null) continue;
                sb.append('\n');
            }
            String string = result = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static SortedSet<String> getEmptyKeys(Map<?, ?> map) {
        TreeSet<String> result = new TreeSet<String>();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (e.getValue() != null && !e.getValue().toString().isEmpty()) continue;
            result.add(e.getKey().toString());
        }
        return result;
    }

    public static boolean addResourceDir(File dir, MavenProject project, String ... includes) {
        List resources = project.getResources();
        boolean added = PluginHelper.addResourceDir(dir, project, resources, includes);
        return added;
    }

    public static boolean addTestResourceDir(File dir, MavenProject project, String ... includes) {
        List resources = project.getTestResources();
        boolean added = PluginHelper.addResourceDir(dir, project, resources, includes);
        return added;
    }

    public static boolean addResourceDir(File dir, MavenProject project, List<?> resources, String ... includes) {
        String newresourceDir = dir.getAbsolutePath();
        boolean shouldAdd = true;
        for (Object o : resources) {
            Resource r = (Resource)o;
            if (!r.getDirectory().equals(newresourceDir)) continue;
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            Resource r = new Resource();
            r.setDirectory(newresourceDir);
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            project.addResource(r);
        }
        return shouldAdd;
    }

    public static boolean createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists()) {
            boolean b = dir.mkdirs();
            if (!b) {
                throw new IOException("Could not create directory " + dir);
            }
            return true;
        }
        return false;
    }

    public static void createNewFile(File file) throws IOException {
        PluginHelper.createDirectoryIfNecessary(file.getParentFile());
        boolean b = file.createNewFile();
        if (!b) {
            throw new IOException("could not create new file " + file);
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        boolean b = file.delete();
        if (!b) {
            throw new IOException("could not delete file " + file);
        }
    }

    public static void renameFile(File file, File destination) throws IOException {
        boolean b = file.renameTo(destination);
        if (!b) {
            throw new IOException("could not rename " + file + " to " + destination);
        }
    }

    public static void setLastModified(File file, long lastModified) throws IOException {
        boolean b = file.setLastModified(lastModified);
        if (!b) {
            throw new IOException("could not changed lastModified [" + lastModified + "] for " + file);
        }
    }

    public static void copy(File source, File target) throws IOException {
        PluginHelper.createDirectoryIfNecessary(target.getParentFile());
        FileUtils.copyFile((File)source, (File)target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inf, encoding));){
            String string = IOUtil.toString((Reader)in);
            return string;
        }
    }

    public static String readAsString(Reader reader) throws IOException {
        return IOUtil.toString((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String content, String encoding) throws IOException {
        PluginHelper.createDirectoryIfNecessary(file.getParentFile());
        BufferedWriter out = null;
        out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        try {
            IOUtil.copy((String)content, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    public static List<File> getIncludedFiles(File dir, String[] includes, String[] excludes) {
        DirectoryScanner ds = new DirectoryScanner();
        ArrayList<File> result = new ArrayList<File>();
        ds.setBasedir(dir);
        if (includes != null) {
            ds.setIncludes(includes);
        }
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        ds.addDefaultExcludes();
        ds.scan();
        for (String file : ds.getIncludedFiles()) {
            File in = new File(dir, file);
            result.add(in);
        }
        return result;
    }

    public static void copyFiles(File src, File dst, String[] includes, String[] excludes, boolean overwrite) throws IOException {
        PluginIOContext c = new PluginIOContext();
        c.setInput(src);
        c.setOutput(dst);
        PluginHelper.copyFiles(c, includes, excludes, overwrite);
    }

    public static void copyFiles(PluginIOContext p, String[] includes, String[] excludes, boolean overwrite) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        for (File input : p.getInputs()) {
            ds.setBasedir(input);
            if (includes != null) {
                ds.setIncludes(includes);
            }
            if (excludes != null) {
                ds.setExcludes(excludes);
            }
            ds.addDefaultExcludes();
            ds.scan();
            for (String file : ds.getIncludedFiles()) {
                File in = new File(input, file);
                File out = new File(p.getOutput(), file);
                if (overwrite) {
                    FileUtils.copyFile((File)in, (File)out);
                    continue;
                }
                FileUtils.copyFileIfModified((File)in, (File)out);
            }
        }
    }

    public static void expandFiles(PluginIOContext p, String[] includes, String[] excludes, String[] zipIncludes, boolean overwrite) throws IOException {
        DirectoryScanner ds = new DirectoryScanner();
        for (File input : p.getInputs()) {
            ds.setBasedir(input);
            if (includes != null) {
                ds.setIncludes(includes);
            }
            if (excludes != null) {
                ds.setExcludes(excludes);
            }
            ds.addDefaultExcludes();
            ds.scan();
            for (String file : ds.getIncludedFiles()) {
                File in = new File(input, file);
                File out = new File(p.getOutput(), file).getParentFile();
                PluginHelper.expandFile(in, out, zipIncludes, overwrite);
            }
        }
    }

    public static File getFile(File base, String ... paths) {
        StringBuilder buffer = new StringBuilder();
        for (String path : paths) {
            buffer.append(File.separator).append(path);
        }
        File f = new File(base, buffer.substring(1));
        return f;
    }

    public static String getRelativePath(File base, File file) {
        String result = file.getAbsolutePath().substring(base.getAbsolutePath().length() + 1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandFile(File src, File dst, String[] includes, boolean overwrite) throws IOException {
        ZipFile zipFile = new ZipFile(src);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry nextElement = entries.nextElement();
            String name = nextElement.getName();
            for (String include : includes) {
                if (!DirectoryScanner.match((String)include, (String)name)) continue;
                System.out.println("matching name : " + name + " with pattern " + include);
                File dstFile = new File(dst, name);
                if (!overwrite && dstFile.exists() && nextElement.getTime() <= dstFile.lastModified()) continue;
                System.out.println("will expand : " + name + " to " + dstFile);
                InputStream inputStream = zipFile.getInputStream(nextElement);
                try (FileOutputStream outStream = new FileOutputStream(dstFile);){
                    IOUtil.copy((InputStream)inputStream, (OutputStream)outStream, (int)2048);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLines(File src) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader stream = new BufferedReader(new InputStreamReader(new FileInputStream(src)));){
            while (stream.ready()) {
                String line = stream.readLine().trim();
                if (line.isEmpty()) continue;
                result.add(line);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static File[] getLinesAsFiles(File src) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (String line : PluginHelper.getLines(src)) {
            if (line.isEmpty()) continue;
            result.add(new File(line));
        }
        return result.toArray(new File[result.size()]);
    }

    public static URL[] getLinesAsURL(File src) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String line : PluginHelper.getLines(src)) {
            if (line.isEmpty()) continue;
            result.add(new URL(line));
        }
        return result.toArray(new URL[result.size()]);
    }

    public static URL getUrl(URL baseUrl, String suffix) throws IllegalArgumentException {
        String url = baseUrl.toString() + "/" + suffix;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("could not obtain url " + url, ex);
        }
    }

    public static void checkEncoding(PluginWithEncoding mojo) {
        if (StringUtils.isEmpty((String)mojo.getEncoding())) {
            mojo.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            mojo.setEncoding(ReaderFactory.FILE_ENCODING);
        }
    }
}

