/**
 * *##% guix-compiler-swing
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags.swing;

import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import org.nuiton.guix.tags.DefaultTagHandler;

/**
 * Super class of all the Swing TagHandlers
 *
 * @author kmorin
 */
public abstract class ComponentHandler extends DefaultTagHandler {

    public ComponentHandler() {
        super();
        configureProxyEventInfo();
        attrMap.put("onLostFocus", "onFocusLost");
        attrMap.put("onFocus", "onFocusGained");
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("hasFocus", FocusListener.class);
        addProxyEventInfo("isVisible", ComponentListener.class);
        addProxyEventInfo("getBounds", ComponentListener.class);
        addProxyEventInfo("getLocation", ComponentListener.class);
        addProxyEventInfo("getLocationOnScreen", ComponentListener.class);
        addProxyEventInfo("getSize", ComponentListener.class);
        addProxyEventInfo("getX", ComponentListener.class);
        addProxyEventInfo("getY", ComponentListener.class);
        addProxyEventInfo("getWidth", ComponentListener.class);
        addProxyEventInfo("getHeight", ComponentListener.class);
    }

}
