/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import org.apache.lucene.index.CompoundFileReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class RebuildSegmentInfo {
    public static void main(String[] args) throws Exception {
        String path = "/home/chris/index";
        File file = new File(path);
        FSDirectory directory = FSDirectory.open((File)file);
        SegmentInfos infos = new SegmentInfos();
        int counter = 0;
        for (String fileName : directory.listAll()) {
            if (directory.fileLength(fileName) == 0L || !fileName.endsWith("cfs")) {
                System.out.println("Skipping " + fileName + ", size " + directory.fileLength(fileName));
                continue;
            }
            System.out.println("Doing " + fileName + ", size " + directory.fileLength(fileName));
            String segmentName = fileName.substring(1, fileName.lastIndexOf(46));
            int segmentInt = Integer.parseInt(segmentName, 36);
            counter = Math.max(counter, segmentInt);
            segmentName = fileName.substring(0, fileName.lastIndexOf(46));
            CompoundFileReader fileReader = new CompoundFileReader((Directory)directory, fileName);
            IndexInput indexStream = fileReader.openInput(segmentName + ".cfs");
            SegmentInfo segmentInfo = new SegmentInfo((Directory)directory, -11, indexStream);
            System.out.println("Name was: \"" + segmentInfo.name + "\"");
            System.out.println("Doc count was: " + segmentInfo.docCount);
            infos.add(segmentInfo);
        }
        infos.counter = ++counter;
        infos.commit((Directory)directory);
    }
}

