/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.legacy.consistency.ConsistencyCheckSettings;
import org.neo4j.legacy.consistency.ConsistencyReportLog;
import org.neo4j.legacy.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.legacy.consistency.checking.full.FullCheck;
import org.neo4j.legacy.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckService {
    private final Date timestamp;

    public ConsistencyCheckService() {
        this(new Date());
    }

    public ConsistencyCheckService(Date timestamp) {
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, FileSystemAbstraction fileSystem) throws ConsistencyCheckIncompleteException, IOException {
        Log log = logProvider.getLog(this.getClass());
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, tuningConfiguration, PageCacheTracer.NULL, logProvider.getLog(PageCache.class));
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        try {
            Result result = this.runFullConsistencyCheck(storeDir, tuningConfiguration, progressFactory, logProvider, fileSystem, pageCache);
            return result;
        }
        finally {
            try {
                pageCache.close();
            }
            catch (IOException e) {
                log.error("Failure during shutdown of the page cache", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result runFullConsistencyCheck(File storeDir, Config tuningConfiguration, ProgressMonitorFactory progressFactory, LogProvider logProvider, final FileSystemAbstraction fileSystem, PageCache pageCache) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary;
        Log log = logProvider.getLog(this.getClass());
        Config consistencyCheckerConfig = tuningConfiguration.with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        StoreFactory factory = new StoreFactory(storeDir, consistencyCheckerConfig, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fileSystem), pageCache, fileSystem, logProvider);
        final File reportFile = this.chooseReportPath(storeDir, tuningConfiguration);
        ConsistencyReportLog reportLog = new ConsistencyReportLog((Supplier<PrintWriter>)Suppliers.lazySingleton((Supplier)new Supplier<PrintWriter>(){

            public PrintWriter get() {
                try {
                    return new PrintWriter(Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)reportFile, (boolean)true));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        try (NeoStores neoStores = factory.openAllNeoStores();){
            StoreAccess store = new StoreAccess(neoStores).initialize();
            LabelScanStore labelScanStore = null;
            try {
                labelScanStore = new LuceneLabelScanStoreBuilder(storeDir, store.getRawNeoStores(), fileSystem, logProvider).build();
                LuceneSchemaIndexProvider indexes = new LuceneSchemaIndexProvider(fileSystem, DirectoryFactory.PERSISTENT, storeDir);
                DirectStoreAccess stores = new DirectStoreAccess(store, labelScanStore, (SchemaIndexProvider)indexes);
                FullCheck check = new FullCheck(tuningConfiguration, progressFactory);
                summary = check.execute(stores, (Log)new DuplicatingLog(new Log[]{log, reportLog}));
            }
            finally {
                try {
                    if (null != labelScanStore) {
                        labelScanStore.shutdown();
                    }
                }
                catch (IOException e) {
                    log.error("Failure during shutdown of label scan store", (Throwable)e);
                }
            }
        }
        if (!summary.isConsistent()) {
            log.warn("See '%s' for a detailed consistency report.", new Object[]{reportFile.getPath()});
            return Result.FAILURE;
        }
        return Result.SUCCESS;
    }

    private File chooseReportPath(File storeDir, Config tuningConfiguration) {
        File reportPath = (File)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_report_file);
        if (reportPath == null) {
            return new File(storeDir, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        if (reportPath.isDirectory()) {
            return new File(reportPath, ConsistencyCheckService.defaultLogFileName(this.timestamp));
        }
        return reportPath;
    }

    public static String defaultLogFileName(Date date) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(date);
        return String.format("inconsistencies-%s.report", formattedDate);
    }

    public static enum Result {
        FAILURE(false),
        SUCCESS(true);

        private final boolean successful;

        private Result(boolean successful) {
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

